/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class UngroupAnnotationsTask
extends AbstractTask {
    private final AnnotationManager annotationManager;
    private final CyNetworkViewManager viewManager;
    private DRenderingEngine re;
    private final RenderingEngineManager reManager;
    private Set<GroupAnnotation> groups;
    @Tunable(description="Network View", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="current", context="nogui")
    public CyNetworkView view = null;
    @Tunable(context="nogui", required=true, description="The UUID or name of the group to be ungrouped")
    public String uuidOrName;

    public UngroupAnnotationsTask(DRenderingEngine re, DingAnnotation annotation) {
        this.re = re;
        this.viewManager = null;
        this.reManager = null;
        this.annotationManager = null;
        if (annotation instanceof GroupAnnotation) {
            this.groups = Collections.singleton((GroupAnnotation)annotation);
        }
    }

    public UngroupAnnotationsTask(DRenderingEngine re, Collection<GroupAnnotation> annotations) {
        this.re = re;
        this.viewManager = null;
        this.reManager = null;
        this.annotationManager = null;
        this.groups = annotations != null ? new LinkedHashSet<GroupAnnotation>(annotations) : Collections.emptySet();
    }

    public UngroupAnnotationsTask(AnnotationManager annotationManager, RenderingEngineManager reManager, CyNetworkViewManager viewManager) {
        this.annotationManager = annotationManager;
        this.viewManager = viewManager;
        this.reManager = reManager;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Ungroup Annotations");
        if (this.view != null && this.reManager != null) {
            this.re = (DRenderingEngine)this.reManager.getRenderingEngines((View)this.view).iterator().next();
            UUID aUUID = null;
            String name = null;
            try {
                aUUID = UUID.fromString(this.uuidOrName);
            }
            catch (IllegalArgumentException e) {
                name = this.uuidOrName.trim();
            }
            for (Annotation annotation : this.annotationManager.getAnnotations(this.view)) {
                if ((aUUID == null || !annotation.getUUID().equals(aUUID)) && (name == null || !annotation.getName().equals(name)) || !(annotation instanceof GroupAnnotation)) continue;
                this.groups = Collections.singleton((GroupAnnotation)annotation);
                break;
            }
            if (this.groups == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find group annotation: " + this.uuidOrName);
                return;
            }
        }
        if (this.re != null) {
            CyAnnotator annotator = this.re.getCyAnnotator();
            annotator.markUndoEdit("Ungroup Annotations");
            for (GroupAnnotation ga : this.groups) {
                GroupAnnotation parent = ((DingAnnotation)ga).getGroupParent();
                List members = ga.getMembers();
                for (Annotation a : members) {
                    ga.removeMember(a);
                    a.setSelected(true);
                }
                if (parent != null) {
                    for (Annotation a : members) {
                        parent.addMember(a);
                    }
                }
                ga.removeAnnotation();
            }
            annotator.postUndoEdit();
        }
    }
}

