/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.ding.impl.cyannotator.tasks.AbstractAnnotationTunables;
import org.cytoscape.ding.internal.util.ColorUtil;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class TextAnnotationTunables
extends AbstractAnnotationTunables {
    private static final String PLAIN = "Plain";
    private static final String BOLD = "Bold";
    private static final String ITALIC = "Italic";
    private static final String BOLD_ITALIC = "BoldItalic";
    private static final String[] FONT_STYLES = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    private static final List<String> fontFamilies = TextAnnotationTunables.getFontFamilies();
    @Tunable(context="nogui", required=true, description="The text to be displayed")
    public String text = null;
    @Tunable(context="nogui", description="The font size")
    public Integer fontSize = null;
    @Tunable(context="nogui", description="The color of the text")
    public String color = null;
    @Tunable(context="nogui", description="The font style (bold, italic, etc.)")
    public String fontStyle = null;
    @Tunable(context="nogui", description="The font family to use")
    public String fontFamily = null;

    public Map<String, String> getArgMap(TaskMonitor tm) {
        HashMap<String, String> args = new HashMap<String, String>();
        this.putIfNotNull(tm, args, "text", this.text);
        this.putIfNotNull(tm, args, "color", this.getColor(this.color));
        this.putIfNotNull(tm, args, "fontStyle", this.getFontStyle(this.fontStyle));
        this.putIfNotNull(tm, args, "fontFamily", this.fontFamily, fontFamilies);
        this.putIfNotNull(tm, args, "fontSize", this.fontSize);
        return args;
    }

    private static List<String> getFontFamilies() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        ArrayList<String> strFonts = new ArrayList<String>();
        for (Font font : fonts) {
            strFonts.add(font.getFamily());
        }
        return strFonts;
    }

    public void update(TaskMonitor tm, Annotation annotation) {
        TextAnnotation tAnnotation = (TextAnnotation)annotation;
        if (this.text != null) {
            tAnnotation.setText(this.text);
        }
        if (this.fontFamily != null) {
            tAnnotation.setFontFamily(this.fontFamily);
        }
        if (this.color != null) {
            tAnnotation.setTextColor(ColorUtil.parseColor(this.color));
        }
        if (this.fontStyle != null) {
            tAnnotation.setFontStyle(this.getFontStyle(this.fontStyle).intValue());
        }
        if (this.fontSize != null) {
            tAnnotation.setFontSize((double)this.fontSize.intValue());
        }
    }

    private Integer getFontStyle(String style) {
        if (style == null) {
            return null;
        }
        if (style.equalsIgnoreCase("bold")) {
            return 1;
        }
        if (style.equalsIgnoreCase("plain")) {
            return 0;
        }
        if (style.equalsIgnoreCase("italic")) {
            return 2;
        }
        if (style.equalsIgnoreCase("bolditalic")) {
            return 3;
        }
        try {
            int code = Integer.parseInt(style);
            if (code == 1 || code == 0 || code == 2 || code == 3) {
                return code;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }
}

