/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.ReorderAnnotationsTask;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class ReorderSelectedAnnotationsTaskFactory
implements NetworkViewTaskFactory {
    private final DingRenderer dingRenderer;
    private String canvasName;
    private AnnotationTree.Shift shift;

    public ReorderSelectedAnnotationsTaskFactory(DingRenderer dingRenderer, String canvasName) {
        this.dingRenderer = dingRenderer;
        this.canvasName = canvasName;
    }

    public ReorderSelectedAnnotationsTaskFactory(DingRenderer dingRenderer, AnnotationTree.Shift shift) {
        this.dingRenderer = dingRenderer;
        this.shift = shift;
    }

    public TaskIterator createTaskIterator(CyNetworkView view) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return null;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        Set<DingAnnotation> annotations = cyAnnotator != null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : Collections.emptySet();
        return new TaskIterator(new Task[]{new ReorderAnnotationsTask(re, annotations, this.canvasName, this.shift)});
    }

    public boolean isReady(CyNetworkView view) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return false;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        List<DingAnnotation> annotations = cyAnnotator.getAnnotationSelection().getSelectedAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        if (this.shift != null) {
            boolean fg = cyAnnotator.getAnnotationTree().shiftAllowed(this.shift, "foreground", annotations);
            boolean bg = cyAnnotator.getAnnotationTree().shiftAllowed(this.shift, "background", annotations);
            return fg || bg;
        }
        if (this.canvasName != null) {
            for (DingAnnotation a : annotations) {
                if (a.getCanvasName().equals(this.canvasName)) continue;
                return true;
            }
        }
        return false;
    }
}

