/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Collection;
import org.cytoscape.ding.impl.cyannotator.AnnotationClipboard;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class PasteAnnotationStyleTask
extends AbstractTask {
    private final Collection<DingAnnotation> annotations;
    private final AnnotationClipboard clipboard;

    public PasteAnnotationStyleTask(Collection<DingAnnotation> annotations, AnnotationClipboard clipboard) {
        this.annotations = annotations;
        this.clipboard = clipboard;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Paste Annotation Style");
        if (this.annotations != null && !this.annotations.isEmpty() && !this.clipboard.isEmpty()) {
            tm.setStatusMessage("Pasting settings to at least " + this.annotations.size() + " annotation(s)...");
            CyAnnotator annotator = this.annotations.iterator().next().getCyAnnotator();
            annotator.markUndoEdit("Paste Style to Annotations");
            this.clipboard.pasteStyle(this.annotations);
            annotator.postUndoEdit();
        }
    }
}

