/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.GroupAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.tasks.AnnotationJsonConverter;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GroupAnnotationsTask
extends AbstractTask
implements ObservableTask {
    private final AnnotationManager annotationManager;
    private final CyNetworkViewManager viewManager;
    private DRenderingEngine re;
    private final RenderingEngineManager reManager;
    private Collection<DingAnnotation> annotations;
    private CyNetworkView savedView = null;
    private GroupAnnotation groupAnnotation;
    @Tunable(description="Network View", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="current", context="nogui")
    public CyNetworkView view = null;
    @Tunable(description="Annotations to group", longDescription="The list of UUIDs or unique names for annotations to be part of this group.  The special keyword 'selected' may also be used.", exampleStringValue="", context="nogui")
    public String annotationlist = null;

    public GroupAnnotationsTask(DRenderingEngine re) {
        this(re, null);
    }

    public GroupAnnotationsTask(DRenderingEngine re, Collection<DingAnnotation> annotations) {
        this.re = re;
        this.reManager = null;
        this.annotations = annotations;
        this.annotationManager = null;
        this.viewManager = null;
    }

    public GroupAnnotationsTask(AnnotationManager annotationManager, RenderingEngineManager reManager, CyNetworkViewManager viewManager) {
        this.re = null;
        this.reManager = reManager;
        this.annotations = null;
        this.annotationManager = annotationManager;
        this.viewManager = viewManager;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Group Annotations");
        if (this.view != null && this.reManager != null) {
            this.re = (DRenderingEngine)this.reManager.getRenderingEngines((View)this.view).iterator().next();
            if (this.annotationlist == null) {
                return;
            }
            if (this.annotationlist.equalsIgnoreCase("selected")) {
                this.annotations = null;
            } else {
                this.annotations = new ArrayList<DingAnnotation>();
                for (String ann : this.annotationlist.split(",")) {
                    DingAnnotation a = this.parseAnnotation(ann.trim());
                    if (a != null) {
                        this.annotations.add(a);
                        continue;
                    }
                    tm.showMessage(TaskMonitor.Level.WARN, "Unable to parse annotation: " + ann.trim());
                }
            }
        }
        if (this.re != null) {
            CyAnnotator cyAnnotator = this.re.getCyAnnotator();
            Collection<DingAnnotation> selectedAnnotations = this.annotations == null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : this.annotations;
            if (selectedAnnotations.isEmpty() || !AnnotationTree.hasSameParent(selectedAnnotations)) {
                return;
            }
            cyAnnotator.markUndoEdit("Group Annotations");
            GroupAnnotation parent = selectedAnnotations.iterator().next().getGroupParent();
            for (DingAnnotation a : selectedAnnotations) {
                GroupAnnotation group = a.getGroupParent();
                if (group == null) continue;
                group.removeMember((Annotation)a);
            }
            GroupAnnotationImpl newGroup = new GroupAnnotationImpl(this.re, Collections.emptyMap());
            for (DingAnnotation a : selectedAnnotations) {
                newGroup.addMember(a);
                a.setSelected(false);
            }
            if (parent != null) {
                parent.addMember((Annotation)newGroup);
            }
            cyAnnotator.addAnnotation(newGroup);
            newGroup.setSelected(true);
            newGroup.update();
            this.groupAnnotation = newGroup;
            cyAnnotator.postUndoEdit();
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class, Annotation.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(Annotation.class)) {
            return (R)this.groupAnnotation;
        }
        if (type.equals(String.class)) {
            Object result = this.groupAnnotation == null ? "Nothing groupd" : "Group annotation " + this.groupAnnotation.toString();
            return (R)result;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.groupAnnotation == null) {
                    return "{}";
                }
                return AnnotationJsonConverter.toJson((DingAnnotation)this.groupAnnotation);
            };
            return (R)res;
        }
        return null;
    }

    private DingAnnotation parseAnnotation(String ann) {
        List allAnnotations = this.annotationManager.getAnnotations(this.view);
        try {
            UUID uuid = UUID.fromString(ann);
            for (Annotation a : allAnnotations) {
                if (!a.getUUID().equals(uuid)) continue;
                return (DingAnnotation)a;
            }
        }
        catch (IllegalArgumentException e) {
            for (Annotation a : allAnnotations) {
                if (!ann.equals(a.getName())) continue;
                return (DingAnnotation)a;
            }
        }
        return null;
    }
}

