/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import org.cytoscape.ding.impl.cyannotator.annotations.ImageAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.ColorButton;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;

public class ImageAnnotationEditor
extends AbstractAnnotationEditor<ImageAnnotation> {
    private JLabel borderWidthLabel;
    private JLabel borderColorLabel;
    private JLabel borderOpacityLabel;
    private JLabel opacityLabel;
    private JLabel brightnessLabel;
    private JLabel contrastLabel;
    private JLabel rotationLabel;
    private ColorButton borderColorButton;
    private JComboBox<Integer> borderWidthCombo;
    private JSlider borderOpacitySlider;
    private JSlider opacitySlider;
    private JSlider brightnessSlider;
    private JSlider contrastSlider;
    private JSlider rotationSlider;

    public ImageAnnotationEditor(AnnotationFactory<ImageAnnotation> factory, CyServiceRegistrar serviceRegistrar) {
        super(factory, serviceRegistrar);
    }

    @Override
    protected void doUpdate() {
        if (this.annotation != null) {
            int borderWidth = (int)Math.round(((ImageAnnotation)this.annotation).getBorderWidth());
            ComboBoxModel<Integer> model = this.getBorderWidthCombo().getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (borderWidth != (Integer)model.getElementAt(i)) continue;
                this.getBorderWidthCombo().setSelectedIndex(i);
                break;
            }
            Paint borderColor = ((ImageAnnotation)this.annotation).getBorderColor();
            this.getBorderColorButton().setColor(borderColor instanceof Color ? (Color)borderColor : Color.BLACK);
            this.getBorderOpacitySlider().setValue((int)((ImageAnnotation)this.annotation).getBorderOpacity());
            this.getOpacitySlider().setValue((int)(((ImageAnnotation)this.annotation).getImageOpacity() * 100.0f));
            this.getBrightnessSlider().setValue(((ImageAnnotation)this.annotation).getImageBrightness());
            this.getContrastSlider().setValue(((ImageAnnotation)this.annotation).getImageContrast());
            this.getRotationSlider().setValue((int)((ImageAnnotation)this.annotation).getRotation());
        } else {
            this.getOpacitySlider().setValue(100);
            this.getBrightnessSlider().setValue(0);
            this.getContrastSlider().setValue(0);
        }
        this.updateEnabled();
        boolean isSVG = this.annotation instanceof ImageAnnotationImpl && ((ImageAnnotationImpl)this.annotation).isSVG();
        this.brightnessLabel.setVisible(!isSVG);
        this.getBrightnessSlider().setVisible(!isSVG);
        this.contrastLabel.setVisible(!isSVG);
        this.getContrastSlider().setVisible(!isSVG);
    }

    @Override
    public void apply(ImageAnnotation annotation) {
        if (annotation != null) {
            annotation.setBorderColor((Paint)this.getBorderColorButton().getColor());
            annotation.setBorderWidth((double)((Integer)this.getBorderWidthCombo().getSelectedItem()).intValue());
            annotation.setBorderOpacity((double)this.getBorderOpacitySlider().getValue());
            annotation.setImageOpacity((float)this.getOpacitySlider().getValue() / 100.0f);
            annotation.setImageBrightness(this.getBrightnessSlider().getValue());
            annotation.setImageContrast(this.getContrastSlider().getValue());
            annotation.setRotation((double)this.getRotationSlider().getValue());
        }
    }

    @Override
    protected void init() {
        this.borderWidthLabel = new JLabel("Border Width:");
        this.borderColorLabel = new JLabel("Border Color:");
        this.borderOpacityLabel = new JLabel("Border Opacity:");
        this.opacityLabel = new JLabel("Opacity:");
        this.brightnessLabel = new JLabel("Brightness:");
        this.contrastLabel = new JLabel("Contrast:");
        this.rotationLabel = ImageAnnotationEditor.createRotationLabel();
        JSeparator sep = new JSeparator();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 20, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.borderWidthLabel).addComponent(this.borderColorLabel).addComponent(this.borderOpacityLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getBorderWidthCombo(), -2, -1, -2).addComponent((Component)this.getBorderColorButton()).addComponent(this.getBorderOpacitySlider(), 100, 140, 140))).addComponent(sep, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.opacityLabel).addComponent(this.brightnessLabel).addComponent(this.contrastLabel).addComponent(this.rotationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getOpacitySlider(), 100, 140, 140).addComponent(this.getBrightnessSlider(), 100, 140, 140).addComponent(this.getContrastSlider(), 100, 140, 140).addComponent(this.getRotationSlider(), 100, 140, 140)))).addGap(0, 20, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.borderWidthLabel).addComponent(this.getBorderWidthCombo(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.borderColorLabel).addComponent((Component)this.getBorderColorButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.borderOpacityLabel).addComponent(this.getBorderOpacitySlider(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.opacityLabel).addComponent(this.getOpacitySlider(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.brightnessLabel).addComponent(this.getBrightnessSlider(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.contrastLabel).addComponent(this.getContrastSlider(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rotationLabel).addComponent(this.getRotationSlider(), -2, -1, -2)));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.borderColorLabel, this.borderOpacityLabel, this.borderWidthLabel, this.opacityLabel, this.brightnessLabel, this.contrastLabel, this.rotationLabel});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getBorderColorButton(), this.getBorderOpacitySlider(), this.getBorderWidthCombo(), this.getOpacitySlider(), this.getBrightnessSlider(), this.getContrastSlider(), this.getRotationSlider()});
    }

    private ColorButton getBorderColorButton() {
        if (this.borderColorButton == null) {
            this.borderColorButton = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.BLACK, false);
            this.borderColorButton.setToolTipText("Select border color...");
            this.borderColorButton.addPropertyChangeListener("color", evt -> this.apply());
        }
        return this.borderColorButton;
    }

    private JSlider getBorderOpacitySlider() {
        if (this.borderOpacitySlider == null) {
            this.borderOpacitySlider = new JSlider(0, 100, 100);
            this.borderOpacitySlider.setMajorTickSpacing(100);
            this.borderOpacitySlider.setMinorTickSpacing(25);
            this.borderOpacitySlider.setPaintTicks(true);
            this.borderOpacitySlider.setPaintLabels(true);
            this.borderOpacitySlider.addChangeListener(evt -> this.apply());
        }
        return this.borderOpacitySlider;
    }

    private JComboBox<Integer> getBorderWidthCombo() {
        if (this.borderWidthCombo == null) {
            this.borderWidthCombo = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13});
            this.borderWidthCombo.setSelectedIndex(0);
            this.borderWidthCombo.addActionListener(evt -> {
                this.updateEnabled();
                this.apply();
            });
        }
        return this.borderWidthCombo;
    }

    private JSlider getOpacitySlider() {
        if (this.opacitySlider == null) {
            this.opacitySlider = new JSlider(0, 100, 100);
            this.opacitySlider.setMajorTickSpacing(100);
            this.opacitySlider.setMinorTickSpacing(25);
            this.opacitySlider.setPaintTicks(true);
            this.opacitySlider.setPaintLabels(true);
            this.opacitySlider.addChangeListener(evt -> this.apply());
        }
        return this.opacitySlider;
    }

    private JSlider getBrightnessSlider() {
        if (this.brightnessSlider == null) {
            this.brightnessSlider = new JSlider(-100, 100, 0);
            this.brightnessSlider.setMajorTickSpacing(100);
            this.brightnessSlider.setMinorTickSpacing(25);
            this.brightnessSlider.setPaintTicks(true);
            this.brightnessSlider.setPaintLabels(true);
            this.brightnessSlider.addChangeListener(evt -> this.apply());
        }
        return this.brightnessSlider;
    }

    private JSlider getContrastSlider() {
        if (this.contrastSlider == null) {
            this.contrastSlider = new JSlider(-100, 100, 0);
            this.contrastSlider.setMajorTickSpacing(100);
            this.contrastSlider.setMinorTickSpacing(25);
            this.contrastSlider.setPaintTicks(true);
            this.contrastSlider.setPaintLabels(true);
            this.contrastSlider.addChangeListener(evt -> this.apply());
        }
        return this.contrastSlider;
    }

    private JSlider getRotationSlider() {
        if (this.rotationSlider == null) {
            this.rotationSlider = this.createRotationSlider();
        }
        return this.rotationSlider;
    }

    private void updateEnabled() {
        int borderWidth = (Integer)this.getBorderWidthCombo().getSelectedItem();
        boolean enabled = borderWidth > 0;
        this.borderColorLabel.setEnabled(enabled);
        this.getBorderColorButton().setEnabled(enabled);
        this.borderOpacityLabel.setEnabled(enabled);
        this.getBorderOpacitySlider().setEnabled(enabled);
    }
}

