/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.undo.AnnotationEdit;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;

public abstract class AbstractAnnotationEditor<T extends Annotation>
extends JPanel
implements PropertyChangeListener {
    protected T annotation;
    protected boolean adjusting;
    protected boolean applying;
    protected final AnnotationFactory<T> factory;
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractAnnotationEditor(AnnotationFactory<T> factory, CyServiceRegistrar serviceRegistrar) {
        this.factory = factory;
        this.serviceRegistrar = serviceRegistrar;
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.init();
        this.update();
    }

    public AnnotationFactory<T> getAnnotationFactory() {
        return this.factory;
    }

    public void setAnnotation(T annotation) {
        if (!Objects.equals(this.annotation, annotation)) {
            if (this.annotation instanceof DingAnnotation) {
                ((DingAnnotation)this.annotation).removePropertyChangeListener(this);
            }
            if (annotation instanceof DingAnnotation) {
                ((DingAnnotation)annotation).addPropertyChangeListener(this);
            }
            this.annotation = annotation;
            this.update();
        }
    }

    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.applying) {
            this.update();
        }
    }

    protected void update() {
        this.adjusting = true;
        try {
            this.doUpdate();
        }
        finally {
            this.adjusting = false;
        }
    }

    protected abstract void doUpdate();

    protected void apply(boolean postUndo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() {
        if (this.annotation != null && !this.adjusting) {
            this.applying = true;
            AnnotationEdit edit = null;
            if (this.annotation instanceof AbstractAnnotation) {
                String label = this.factory == null ? "Edit Annotation" : "Edit " + this.factory.getName() + " Annotation";
                DRenderingEngine re = ((AbstractAnnotation)this.annotation).getRenderingEngine();
                edit = new AnnotationEdit(label, re);
            }
            try {
                this.apply(this.annotation);
                if (edit != null) {
                    edit.post();
                }
            }
            finally {
                this.applying = false;
            }
        }
    }

    public abstract void apply(T var1);

    protected abstract void init();

    protected static JLabel createRotationLabel() {
        JLabel label = new JLabel("Rotation Angle:");
        return label;
    }

    protected JSlider createRotationSlider() {
        JSlider slider = new JSlider(-180, 180, 0);
        slider.setMajorTickSpacing(90);
        slider.setMinorTickSpacing(45);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.addChangeListener(evt -> this.apply());
        return slider;
    }
}

