/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.ShapeAnnotationImpl;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;

public class GraphicsUtilities {
    private static double halfPI = 1.5707963267948966;

    public static Shape getShape(String shapeName, double x, double y, double width, double height) {
        ShapeAnnotation.ShapeType shapeType = GraphicsUtilities.getShapeType(shapeName);
        switch (shapeType) {
            case RECTANGLE: {
                return GraphicsUtilities.rectangleShape(x, y, width, height);
            }
            case ROUNDEDRECTANGLE: {
                return GraphicsUtilities.roundedRectangleShape(x, y, width, height);
            }
            case ELLIPSE: {
                return GraphicsUtilities.ellipseShape(x, y, width, height);
            }
            case STAR5: {
                return GraphicsUtilities.starShape(5, x, y, width, height);
            }
            case STAR6: {
                return GraphicsUtilities.starShape(6, x, y, width, height);
            }
            case TRIANGLE: {
                return GraphicsUtilities.regularPolygon(3, x, y, width, height);
            }
            case PENTAGON: {
                return GraphicsUtilities.regularPolygon(5, x, y, width, height);
            }
            case HEXAGON: {
                return GraphicsUtilities.regularPolygon(6, x, y, width, height);
            }
            case OCTAGON: {
                return GraphicsUtilities.regularPolygon(8, x, y, width, height);
            }
            case PARALLELOGRAM: {
                return GraphicsUtilities.parallelogramShape(x, y, width, height);
            }
            case DIAMOND: {
                return GraphicsUtilities.diamondShape(x, y, width, height);
            }
            case V: {
                return GraphicsUtilities.vShape(x, y, width, height);
            }
            case CUSTOM: {
                return null;
            }
        }
        return GraphicsUtilities.rectangleShape(x, y, width, height);
    }

    public static ShapeAnnotation.ShapeType getShapeType(String shapeName) {
        for (ShapeAnnotation.ShapeType type : ShapeAnnotation.ShapeType.values()) {
            if (!shapeName.equals(type.shapeName())) continue;
            return type;
        }
        return ShapeAnnotation.ShapeType.RECTANGLE;
    }

    public static ShapeAnnotation.ShapeType getShapeType(Map<String, String> argMap, String key, ShapeAnnotation.ShapeType defValue) {
        if (!argMap.containsKey(key) || argMap.get(key) == null) {
            return defValue;
        }
        String shapeString = argMap.get(key);
        for (ShapeAnnotation.ShapeType type : ShapeAnnotation.ShapeType.values()) {
            if (!shapeString.equalsIgnoreCase(type.shapeName()) && !shapeString.equalsIgnoreCase(type.name())) continue;
            return type;
        }
        return defValue;
    }

    public static List<String> getSupportedShapes() {
        return Arrays.stream(ShapeAnnotation.ShapeType.values()).map(ShapeAnnotation.ShapeType::shapeName).collect(Collectors.toList());
    }

    public static void drawShape(Graphics g, double x, double y, double width, double height, double rotation, ShapeAnnotation annotation, boolean isPrinting) {
        Graphics2D g2 = (Graphics2D)g;
        float border = (float)(annotation.getBorderWidth() * annotation.getZoom());
        Shape shape = null;
        if (annotation.getShapeType().equals(ShapeAnnotation.ShapeType.CUSTOM.shapeName())) {
            double destX = x + (double)border;
            double destY = y + (double)border;
            double destW = width - (double)border;
            double destH = height - (double)border;
            shape = annotation.getShape();
            if (shape == null) {
                return;
            }
            Rectangle2D originalBounds = shape.getBounds2D();
            double widthScale = destW / originalBounds.getWidth();
            double heightScale = destH / originalBounds.getHeight();
            AffineTransform transform = new AffineTransform();
            transform.translate(destX, destY);
            transform.scale(widthScale, heightScale);
            transform.translate(-originalBounds.getX(), -originalBounds.getY());
            transform.rotate(Math.toRadians(rotation), destX + destW / 2.0, destY + destH / 2.0);
            shape = transform.createTransformedShape(shape);
        } else if (rotation == 0.0) {
            shape = GraphicsUtilities.getShape(annotation.getShapeType(), x, y, width, height);
        } else {
            shape = GraphicsUtilities.getShape(annotation.getShapeType(), x, y, width, height);
            AffineTransform transform = new AffineTransform();
            transform.rotate(Math.toRadians(rotation), x + width / 2.0, y + height / 2.0);
            shape = transform.createTransformedShape(shape);
        }
        if (annotation.getFillColor() != null) {
            Paint fillColor = annotation.getFillColor();
            fillColor = GraphicsUtilities.fixGradients(fillColor, shape);
            g2.setPaint(fillColor);
            float opacity = GraphicsUtilities.clamp((float)(annotation.getFillOpacity() / 100.0), 0.0f, 1.0f);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, opacity));
            g2.fill(shape);
            g2.setComposite(originalComposite);
        }
        if (border > 0.0f) {
            float opacity = GraphicsUtilities.clamp((float)(((ShapeAnnotationImpl)annotation).getBorderOpacity() / 100.0), 0.0f, 1.0f);
            Composite originalComposite = g2.getComposite();
            Paint color = annotation.getBorderColor();
            if (color == null) {
                color = Color.BLACK;
            }
            g2.setPaint(color);
            g2.setComposite(AlphaComposite.getInstance(3, opacity));
            g2.setStroke(new BasicStroke(border));
            g2.draw(shape);
            g2.setComposite(originalComposite);
        }
    }

    public static Shape copyCustomShape(Shape s, double width, double height) {
        Rectangle bounds = s.getBounds();
        double sx = width / bounds.getWidth();
        double sy = height / bounds.getHeight();
        AffineTransform t = AffineTransform.getScaleInstance(sx, sy);
        PathIterator i = s.getPathIterator(t);
        Path2D.Double path = new Path2D.Double();
        path.setWindingRule(i.getWindingRule());
        double[] nums = new double[6];
        while (!i.isDone()) {
            int type = i.currentSegment(nums);
            switch (type) {
                case 4: {
                    path.closePath();
                    break;
                }
                case 0: {
                    path.moveTo(nums[0], nums[1]);
                    break;
                }
                case 1: {
                    path.lineTo(nums[0], nums[1]);
                    break;
                }
                case 2: {
                    path.quadTo(nums[0], nums[1], nums[2], nums[3]);
                    break;
                }
                case 3: {
                    path.curveTo(nums[0], nums[1], nums[2], nums[3], nums[4], nums[5]);
                }
            }
            i.next();
        }
        return path;
    }

    public static String serializeShape(Shape s) {
        StringBuffer buffer = new StringBuffer();
        PathIterator i = s.getPathIterator(null);
        switch (i.getWindingRule()) {
            case 0: {
                buffer.append("EO ");
                break;
            }
            case 1: {
                buffer.append("NZ ");
            }
        }
        double[] nums = new double[6];
        while (!i.isDone()) {
            int type = i.currentSegment(nums);
            switch (type) {
                case 4: {
                    buffer.append("Z ");
                    break;
                }
                case 0: {
                    buffer.append("M ");
                    buffer.append(nums[0]);
                    buffer.append(' ');
                    buffer.append(nums[1]);
                    buffer.append(' ');
                    break;
                }
                case 1: {
                    buffer.append("L ");
                    buffer.append(nums[0]);
                    buffer.append(' ');
                    buffer.append(nums[1]);
                    buffer.append(' ');
                    break;
                }
                case 2: {
                    buffer.append("Q ");
                    buffer.append(nums[0]);
                    buffer.append(' ');
                    buffer.append(nums[1]);
                    buffer.append(' ');
                    buffer.append(nums[2]);
                    buffer.append(' ');
                    buffer.append(nums[3]);
                    buffer.append(' ');
                    break;
                }
                case 3: {
                    buffer.append("C ");
                    buffer.append(nums[0]);
                    buffer.append(' ');
                    buffer.append(nums[1]);
                    buffer.append(' ');
                    buffer.append(nums[2]);
                    buffer.append(' ');
                    buffer.append(nums[3]);
                    buffer.append(' ');
                    buffer.append(nums[4]);
                    buffer.append(' ');
                    buffer.append(nums[5]);
                    buffer.append(' ');
                }
            }
            i.next();
        }
        return buffer.toString();
    }

    public static Shape deserializeShape(String str) {
        Path2D.Double path = new Path2D.Double();
        String[] pieces = str.split("\\p{Space}+");
        double[] nums = new double[6];
        int i = 0;
        while (i < pieces.length) {
            String cmd = pieces[i];
            ++i;
            if (cmd.equalsIgnoreCase("z")) {
                path.closePath();
                continue;
            }
            if (cmd.equalsIgnoreCase("zm")) {
                path.closePath();
                i += GraphicsUtilities.parseDoubles(pieces, i, 2, nums);
                path.moveTo(nums[0], nums[1]);
                continue;
            }
            if (cmd.equalsIgnoreCase("eo")) {
                path.setWindingRule(0);
                continue;
            }
            if (cmd.equalsIgnoreCase("nz")) {
                path.setWindingRule(1);
                continue;
            }
            if (cmd.equalsIgnoreCase("m")) {
                i += GraphicsUtilities.parseDoubles(pieces, i, 2, nums);
                path.moveTo(nums[0], nums[1]);
                continue;
            }
            if (cmd.equalsIgnoreCase("l")) {
                i += GraphicsUtilities.parseDoubles(pieces, i, 2, nums);
                path.lineTo(nums[0], nums[1]);
                continue;
            }
            if (cmd.equalsIgnoreCase("q")) {
                i += GraphicsUtilities.parseDoubles(pieces, i, 4, nums);
                path.quadTo(nums[0], nums[1], nums[2], nums[3]);
                continue;
            }
            if (cmd.equalsIgnoreCase("c")) {
                i += GraphicsUtilities.parseDoubles(pieces, i, 6, nums);
                path.curveTo(nums[0], nums[1], nums[2], nums[3], nums[4], nums[5]);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown command '%s': %s", cmd, str));
        }
        return path;
    }

    private static int parseDoubles(String[] pieces, int startIndex, int expectedNum, double[] nums) {
        if (startIndex + expectedNum > pieces.length) {
            throw new IllegalArgumentException(String.format("Command expects at least %d arguments", expectedNum));
        }
        for (int i = 0; i < expectedNum; ++i) {
            String num = pieces[i + startIndex];
            try {
                nums[i] = Double.parseDouble(num);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid number", num));
            }
        }
        return expectedNum;
    }

    public static Shape getArrowShape(ArrowAnnotationImpl.ArrowType arrowType, double size) {
        switch (arrowType) {
            case CIRCLE: {
                return GraphicsUtilities.circleArrow(size);
            }
            case CLOSED: {
                return GraphicsUtilities.closedArrow(size);
            }
            case CONCAVE: {
                return GraphicsUtilities.concaveArrow(size);
            }
            case DIAMOND: {
                return GraphicsUtilities.diamondArrow(size);
            }
            case OPEN: {
                return GraphicsUtilities.openArrow(size);
            }
            case TRIANGLE: {
                return GraphicsUtilities.triangleArrow(size);
            }
            case TSHAPE: {
                return GraphicsUtilities.tshapeArrow(size);
            }
            case X: {
                return GraphicsUtilities.xArrow(size);
            }
        }
        return null;
    }

    public static ArrowAnnotationImpl.ArrowType getArrowType(String arrowName) {
        for (ArrowAnnotationImpl.ArrowType type : ArrowAnnotationImpl.ArrowType.values()) {
            if (!arrowName.equals(type.getName())) continue;
            return type;
        }
        return ArrowAnnotationImpl.ArrowType.NONE;
    }

    public static ArrowAnnotationImpl.ArrowType getArrowType(Map<String, String> argMap, String key, ArrowAnnotationImpl.ArrowType defValue) {
        if (argMap.get(key) == null) {
            return defValue;
        }
        int arrowNumber = Integer.parseInt(argMap.get(key));
        for (ArrowAnnotationImpl.ArrowType type : ArrowAnnotationImpl.ArrowType.values()) {
            if (arrowNumber != type.ordinal()) continue;
            return type;
        }
        return defValue;
    }

    public static ArrowAnnotationImpl.ArrowType[] getSupportedArrowTypes() {
        return ArrowAnnotationImpl.ArrowType.values();
    }

    public static List<String> getSupportedArrowTypeNames() {
        return Arrays.stream(ArrowAnnotationImpl.ArrowType.values()).map(ArrowAnnotationImpl.ArrowType::getName).collect(Collectors.toList());
    }

    public static void drawArrow(Graphics g, Line2D line, ArrowAnnotation.ArrowEnd end, Paint paint, double size, ArrowAnnotationImpl.ArrowType type) {
        if (line == null) {
            return;
        }
        Shape arrow = GraphicsUtilities.getArrowShape(type, size);
        arrow = end == ArrowAnnotation.ArrowEnd.SOURCE ? GraphicsUtilities.transformArrowShape(arrow, line.getX2(), line.getY2(), line.getX1(), line.getY1()) : GraphicsUtilities.transformArrowShape(arrow, line.getX1(), line.getY1(), line.getX2(), line.getY2());
        Graphics2D g2 = (Graphics2D)g.create();
        if (paint != null) {
            g2.setPaint(paint);
        }
        if (paint instanceof Color) {
            int alpha = ((Color)paint).getAlpha();
            float opacity = (float)alpha / 255.0f;
            g2.setComposite(AlphaComposite.getInstance(3, opacity));
        }
        if (type != ArrowAnnotationImpl.ArrowType.OPEN && type != ArrowAnnotationImpl.ArrowType.TSHAPE && type != ArrowAnnotationImpl.ArrowType.X) {
            g2.fill(arrow);
        }
        g2.draw(arrow);
        g2.dispose();
    }

    private static Shape rectangleShape(double x, double y, double width, double height) {
        return new Rectangle2D.Double(x, y, width, height);
    }

    private static Shape parallelogramShape(double x, double y, double width, double height) {
        Path2D.Double poly = new Path2D.Double(0, 4);
        double xMax = x + width;
        double yMax = y + height;
        ((Path2D)poly).moveTo(x, y);
        ((Path2D)poly).lineTo((2.0 * xMax + x) / 3.0, y);
        ((Path2D)poly).lineTo(xMax, yMax);
        ((Path2D)poly).lineTo((2.0 * x + xMax) / 3.0, yMax);
        poly.closePath();
        return poly;
    }

    private static Shape diamondShape(double x, double y, double width, double height) {
        Path2D.Double poly = new Path2D.Double(0, 4);
        double xMax = x + width;
        double yMax = y + height;
        double xMid = x + width / 2.0;
        double yMid = y + height / 2.0;
        ((Path2D)poly).moveTo(xMid, y);
        ((Path2D)poly).lineTo(xMax, yMid);
        ((Path2D)poly).lineTo(xMid, yMax);
        ((Path2D)poly).lineTo(x, yMid);
        poly.closePath();
        return poly;
    }

    private static Shape vShape(double x, double y, double width, double height) {
        Path2D.Double poly = new Path2D.Double(0, 4);
        double xMax = x + width;
        double yMax = y + height;
        double xMid = x + width / 2.0;
        double yMid = y + height / 2.0;
        ((Path2D)poly).moveTo(x, y);
        ((Path2D)poly).lineTo(xMid, yMid);
        ((Path2D)poly).lineTo(xMax, y);
        ((Path2D)poly).lineTo(xMid, yMax);
        poly.closePath();
        return poly;
    }

    private static Shape roundedRectangleShape(double x, double y, double width, double height) {
        return new RoundRectangle2D.Double(x, y, width, height, width / 10.0, width / 10.0);
    }

    private static Shape ellipseShape(double x, double y, double width, double height) {
        return new Ellipse2D.Double(x, y, width, height);
    }

    private static Shape regularPolygon(int sides, double x, double y, double width, double height) {
        int i;
        Path2D.Double poly = new Path2D.Double(0, sides);
        x += (width /= 2.0);
        y += (height /= 2.0);
        Point2D.Double[] points = new Point2D.Double[sides];
        for (i = 0; i < sides; ++i) {
            double x1 = GraphicsUtilities.circleX(sides, i, true) * width + x;
            double y1 = GraphicsUtilities.circleY(sides, i, true) * height + y;
            points[i] = new Point2D.Double(x1, y1);
        }
        ((Path2D)poly).moveTo(points[0].getX(), points[0].getY());
        for (i = 1; i < sides; ++i) {
            ((Path2D)poly).lineTo(points[i].getX(), points[i].getY());
        }
        poly.closePath();
        return poly;
    }

    private static Shape starShape(int sides, double x, double y, double width, double height) {
        int i;
        Path2D.Double poly = new Path2D.Double(0, sides);
        x += (width /= 2.0);
        y += (height /= 2.0);
        int nPoints = sides * 2;
        Point2D.Double[] points = new Point2D.Double[nPoints];
        for (i = 0; i < sides; ++i) {
            double x1 = GraphicsUtilities.circleX(sides, i, false) * width + x;
            double y1 = GraphicsUtilities.circleY(sides, i, false) * height + y;
            double x2 = GraphicsUtilities.circleX(sides, (i + 2) % sides, false) * width + x;
            double y2 = GraphicsUtilities.circleY(sides, (i + 2) % sides, false) * height + y;
            points[i * 2] = new Point2D.Double(x1, y1);
            points[(i * 2 + 4) % nPoints] = new Point2D.Double(x2, y2);
        }
        for (i = 0; i < nPoints; i += 2) {
            int p1 = i;
            int p2 = (i + 4) % nPoints;
            int p3 = (i + 2) % nPoints;
            int p4 = (p3 + nPoints - 4) % nPoints;
            points[(i + 1) % nPoints] = GraphicsUtilities.findIntersection(points[p1], points[p2], points[p3], points[p4]);
        }
        ((Path2D)poly).moveTo(points[0].getX(), points[0].getY());
        for (i = 1; i < nPoints; ++i) {
            ((Path2D)poly).lineTo(points[i].getX(), points[i].getY());
        }
        poly.closePath();
        return poly;
    }

    static Shape openArrow(double size) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-size * 1.7, -size / 2.0);
        ((Path2D)path).lineTo(0.0, 0.0);
        ((Path2D)path).lineTo(-size * 1.7, size / 2.0);
        return path;
    }

    static Shape closedArrow(double size) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-size * 1.7, -size / 2.0);
        ((Path2D)path).lineTo(0.0, 0.0);
        ((Path2D)path).lineTo(-size * 1.7, size / 2.0);
        path.closePath();
        return path;
    }

    static Shape concaveArrow(double size) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-size, 0.0);
        ((Path2D)path).lineTo(-size * 1.7, -size / 2.0);
        ((Path2D)path).lineTo(0.0, 0.0);
        ((Path2D)path).lineTo(-size * 1.7, size / 2.0);
        path.closePath();
        return path;
    }

    static Shape diamondArrow(double size) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-size * 1.7 * 2.0, 0.0);
        ((Path2D)path).lineTo(-size * 1.7, size);
        ((Path2D)path).lineTo(0.0, 0.0);
        ((Path2D)path).lineTo(-size * 1.7, -size);
        path.closePath();
        return path;
    }

    static Shape triangleArrow(double size) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(0.0, 0.0);
        ((Path2D)path).lineTo(-size / 2.0, -size / 2.0);
        ((Path2D)path).lineTo(-size / 2.0, size / 2.0);
        path.closePath();
        return path;
    }

    static Shape tshapeArrow(double size) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(0.0, size / 2.0);
        ((Path2D)path).lineTo(0.0, -size / 2.0);
        return path;
    }

    static Shape xArrow(double size) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(size / 2.0, -size / 2.0);
        ((Path2D)path).lineTo(-size / 2.0, size / 2.0);
        ((Path2D)path).moveTo(-size / 2.0, -size / 2.0);
        ((Path2D)path).lineTo(size / 2.0, size / 2.0);
        return path;
    }

    static Shape circleArrow(double size) {
        Ellipse2D.Double circle = new Ellipse2D.Double(-size, -size / 2.0, size, size);
        return circle;
    }

    static double circleX(int sides, int angle, boolean rot) {
        double coeff = (double)angle / (double)sides;
        if (rot && sides % 2 == 0) {
            if (sides == 8) {
                coeff += 0.5 / (double)sides;
            }
            return GraphicsUtilities.epsilon(Math.cos(2.0 * coeff * Math.PI));
        }
        return GraphicsUtilities.epsilon(Math.cos(2.0 * coeff * Math.PI - halfPI));
    }

    static double circleY(int sides, int angle, boolean rot) {
        double coeff = (double)angle / (double)sides;
        if (rot && sides % 2 == 0) {
            if (sides == 8) {
                coeff += 0.5 / (double)sides;
            }
            return GraphicsUtilities.epsilon(Math.sin(2.0 * coeff * Math.PI));
        }
        return GraphicsUtilities.epsilon(Math.sin(2.0 * coeff * Math.PI - halfPI));
    }

    static double epsilon(double v) {
        if (Math.abs(v) < 1.0E-10) {
            return 0.0;
        }
        return v;
    }

    static Point2D.Double findIntersection(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, Point2D.Double p4) {
        double denominator = (p4.getY() - p3.getY()) * (p2.getX() - p1.getX()) - (p4.getX() - p3.getX()) * (p2.getY() - p1.getY());
        double ua = ((p4.getX() - p3.getX()) * (p1.getY() - p3.getY()) - (p4.getY() - p3.getY()) * (p1.getX() - p3.getX())) / denominator;
        double x = GraphicsUtilities.epsilon(p1.getX() + ua * (p2.getX() - p1.getX()));
        double y = GraphicsUtilities.epsilon(p1.getY() + ua * (p2.getY() - p1.getY()));
        return new Point2D.Double(x, y);
    }

    static Shape transformArrowShape(Shape arrow, double x1, double y1, double x2, double y2) {
        double angle = Math.atan2(y2 - y1, x2 - x1);
        AffineTransform trans = new AffineTransform();
        trans.translate(x2, y2);
        trans.rotate(angle);
        arrow = trans.createTransformedShape(arrow);
        return arrow;
    }

    private static Paint mixColor(Paint p, double value) {
        if (p == null || !(p instanceof Color)) {
            return p;
        }
        Color c = (Color)p;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)value * 255 / 100);
    }

    private static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static Paint fixGradients(Paint paint, Shape shape) {
        if (paint instanceof MultipleGradientPaint) {
            MultipleGradientPaint mgp = (MultipleGradientPaint)paint;
            float[] fractions = mgp.getFractions();
            Color[] colors = mgp.getColors();
            Rectangle bounds = shape.getBounds();
            AffineTransform tr = mgp.getTransform();
            tr.translate(bounds.getX(), bounds.getY());
            tr.scale(bounds.getWidth(), bounds.getHeight());
            if (paint instanceof LinearGradientPaint) {
                LinearGradientPaint lgp = (LinearGradientPaint)paint;
                Point2D start = lgp.getStartPoint();
                Point2D end = lgp.getEndPoint();
                return new LinearGradientPaint(start, end, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, tr);
            }
            if (paint instanceof RadialGradientPaint) {
                RadialGradientPaint rgp = (RadialGradientPaint)paint;
                Point2D center = rgp.getCenterPoint();
                Point2D focus = rgp.getFocusPoint();
                float radius = rgp.getRadius();
                return new RadialGradientPaint(center, radius, focus, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, tr);
            }
        }
        return paint;
    }
}

