/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.GraphicsUtilities;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;

public class ArrowAnnotationImpl
extends AbstractAnnotation
implements ArrowAnnotation {
    private Paint lineColor = Color.BLACK;
    private float lineWidth = 1.0f;
    private DingAnnotation source;
    private ArrowType sourceType = ArrowType.NONE;
    private ArrowAnnotation.AnchorType sourceAnchorType = ArrowAnnotation.AnchorType.ANCHOR;
    private Paint sourceColor;
    private double sourceSize = 1.0;
    private Object target;
    private ArrowType targetType = ArrowType.OPEN;
    private ArrowAnnotation.AnchorType targetAnchorType = ArrowAnnotation.AnchorType.ANCHOR;
    private Paint targetColor;
    private double targetSize = 1.0;
    private double xOffset;
    private double yOffset;
    private Line2D arrowLine;
    public static final String ARROWCOLOR = "lineColor";
    protected static final String ARROWTHICKNESS = "lineThickness";
    protected static final String SOURCEANN = "sourceAnnotation";
    protected static final String SOURCETYPE = "sourceType";
    protected static final String SOURCESIZE = "sourceSize";
    public static final String SOURCECOLOR = "sourceColor";
    protected static final String TARGETPOINT = "targetPoint";
    protected static final String TARGETANN = "targetAnnotation";
    protected static final String TARGETNODE = "targetNode";
    protected static final String TARGETTYPE = "targetType";
    protected static final String TARGETSIZE = "targetSize";
    public static final String TARGETCOLOR = "targetColor";

    public ArrowAnnotationImpl(DRenderingEngine re, boolean usedForPreviews) {
        super(re, usedForPreviews);
    }

    public ArrowAnnotationImpl(DRenderingEngine re, Map<String, String> argMap) {
        super(re, argMap);
        String point;
        UUID uuid;
        this.lineColor = ViewUtils.getColor(argMap, ARROWCOLOR, Color.BLACK);
        double zoom = ArrowAnnotationImpl.getLegacyZoom(argMap);
        this.lineWidth = ViewUtils.getFloat(argMap, ARROWTHICKNESS, 1.0f).floatValue() / (float)zoom;
        if (argMap.containsKey(SOURCEANN)) {
            uuid = UUID.fromString(argMap.get(SOURCEANN));
            this.source = this.cyAnnotator.getAnnotation(uuid);
        }
        this.sourceType = GraphicsUtilities.getArrowType(argMap, SOURCETYPE, ArrowType.NONE);
        this.sourceSize = ViewUtils.getDouble(argMap, SOURCESIZE, 5.0);
        this.sourceColor = ViewUtils.getColor(argMap, SOURCECOLOR, null);
        this.targetType = GraphicsUtilities.getArrowType(argMap, TARGETTYPE, ArrowType.NONE);
        this.targetSize = ViewUtils.getDouble(argMap, TARGETSIZE, 5.0);
        this.targetColor = ViewUtils.getColor(argMap, TARGETCOLOR, null);
        if (argMap.containsKey(TARGETPOINT)) {
            point = argMap.get(TARGETPOINT);
            String[] xy = point.split(",");
            double x = Double.parseDouble(xy[0]);
            double y = Double.parseDouble(xy[1]);
            this.target = new Point2D.Double(x, y);
        } else if (argMap.containsKey(TARGETANN)) {
            uuid = UUID.fromString(argMap.get(TARGETANN));
            this.target = this.cyAnnotator.getAnnotation(uuid);
        } else if (argMap.containsKey(TARGETNODE)) {
            point = argMap.get(TARGETNODE);
            String[] xy = point.split(",");
            double centerX = Double.parseDouble(xy[0]);
            double centerY = Double.parseDouble(xy[1]);
            this.target = re.getPicker().getNodeForArrowAnnotation(centerX, centerY);
        }
        this.updateBounds();
    }

    @Override
    public Class<? extends Annotation> getType() {
        return ArrowAnnotation.class;
    }

    @Override
    public Map<String, String> getArgMap() {
        View nv;
        Map<String, String> argMap = super.getArgMap();
        argMap.put("type", ArrowAnnotation.class.getName());
        if (this.lineColor != null) {
            argMap.put(ARROWCOLOR, ViewUtils.convertColor(this.lineColor));
        }
        argMap.put(ARROWTHICKNESS, Float.toString(this.lineWidth));
        if (this.source != null) {
            argMap.put(SOURCEANN, this.source.getUUID().toString());
        }
        argMap.put(SOURCETYPE, Integer.toString(this.sourceType.ordinal()));
        argMap.put(SOURCESIZE, Double.toString(this.sourceSize));
        if (this.sourceColor != null) {
            argMap.put(SOURCECOLOR, ViewUtils.convertColor(this.sourceColor));
        }
        if (this.target instanceof Point2D) {
            Point2D xy = (Point2D)this.target;
            argMap.put(TARGETPOINT, Double.toString(xy.getX()) + "," + Double.toString(xy.getY()));
        } else if (this.target instanceof Annotation) {
            argMap.put(TARGETANN, ((DingAnnotation)this.target).getUUID().toString());
        } else if (this.target instanceof View && (nv = (View)this.target) != null) {
            double xCenter = this.re.getNodeDetails().getXPosition((View<CyNode>)nv);
            double yCenter = this.re.getNodeDetails().getYPosition((View<CyNode>)nv);
            argMap.put(TARGETNODE, Double.toString(xCenter) + "," + Double.toString(yCenter));
        }
        argMap.put(TARGETTYPE, Integer.toString(this.targetType.ordinal()));
        argMap.put(TARGETSIZE, Double.toString(this.targetSize));
        if (this.targetColor != null) {
            argMap.put(TARGETCOLOR, ViewUtils.convertColor(this.targetColor));
        }
        return argMap;
    }

    @Override
    public void setStyle(Map<String, String> argMap) {
        if (argMap != null) {
            this.setLineColor(ViewUtils.getColor(argMap, ARROWCOLOR, Color.BLACK));
            double zoom = ArrowAnnotationImpl.getLegacyZoom(argMap);
            this.setLineWidth(ViewUtils.getFloat(argMap, ARROWTHICKNESS, 1.0f).floatValue() / (float)zoom);
            this.setArrowType(ArrowAnnotation.ArrowEnd.SOURCE, GraphicsUtilities.getArrowType(argMap, SOURCETYPE, ArrowType.NONE).getName());
            this.setArrowSize(ArrowAnnotation.ArrowEnd.SOURCE, ViewUtils.getDouble(argMap, SOURCESIZE, 5.0));
            this.setArrowColor(ArrowAnnotation.ArrowEnd.SOURCE, ViewUtils.getColor(argMap, SOURCECOLOR, null));
            this.setArrowType(ArrowAnnotation.ArrowEnd.TARGET, GraphicsUtilities.getArrowType(argMap, TARGETTYPE, ArrowType.NONE).getName());
            this.setArrowSize(ArrowAnnotation.ArrowEnd.TARGET, ViewUtils.getDouble(argMap, TARGETSIZE, 5.0));
            this.setArrowColor(ArrowAnnotation.ArrowEnd.TARGET, ViewUtils.getColor(argMap, TARGETCOLOR, null));
        }
    }

    public Annotation getSource() {
        return this.source;
    }

    public void setSource(Annotation source) {
        if (this.source != null) {
            ((DingAnnotation)source).removeArrow(this);
        }
        this.source = (DingAnnotation)source;
        if (source != null) {
            source.addArrow((ArrowAnnotation)this);
        }
        this.update();
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Annotation target) {
        if (!Objects.equals(this.target, target)) {
            this.target = target;
            this.update();
        }
    }

    @Deprecated
    public void setTarget(CyNode target) {
        View nv = this.re.getViewModelSnapshot().getNodeView(target);
        this.setTarget((View<? extends CyIdentifiable>)nv);
    }

    public void setTarget(View<? extends CyIdentifiable> target) {
        if (!Objects.equals(this.target, target)) {
            this.target = target;
            this.update();
        }
    }

    public void setTarget(Point2D target) {
        if (!Objects.equals(this.target, target)) {
            this.target = target;
            this.update();
        }
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double width) {
        if (this.lineWidth != (float)width) {
            float oldValue = this.lineWidth;
            this.lineWidth = (float)width;
            this.update();
            this.firePropertyChange("lineWidth", Float.valueOf(oldValue), width);
        }
    }

    public double getArrowSize(ArrowAnnotation.ArrowEnd end) {
        return end == ArrowAnnotation.ArrowEnd.SOURCE ? this.sourceSize : this.targetSize;
    }

    public void setArrowSize(ArrowAnnotation.ArrowEnd end, double width) {
        String propName = null;
        double oldValue = 0.0;
        if (end == ArrowAnnotation.ArrowEnd.SOURCE) {
            if (this.sourceSize != width) {
                oldValue = this.sourceSize;
                this.sourceSize = width;
                propName = "sourceArrowSize";
            }
        } else if (this.targetSize != width) {
            oldValue = this.targetSize;
            this.targetSize = width;
            propName = "targetArrowSize";
        }
        if (propName != null) {
            this.update();
            this.firePropertyChange(propName, oldValue, width);
        }
    }

    public String getArrowType(ArrowAnnotation.ArrowEnd end) {
        return end == ArrowAnnotation.ArrowEnd.SOURCE ? this.sourceType.getName() : this.targetType.getName();
    }

    public void setArrowType(ArrowAnnotation.ArrowEnd end, String type) {
        ArrowType aType = null;
        for (ArrowType t : ArrowType.values()) {
            if (!t.getName().equals(type)) continue;
            aType = t;
            break;
        }
        if (aType == null) {
            return;
        }
        String propName = null;
        ArrowType oldValue = null;
        if (end == ArrowAnnotation.ArrowEnd.SOURCE) {
            if (this.sourceType != aType) {
                oldValue = this.sourceType;
                this.sourceType = aType;
                propName = "sourceArrowType";
            }
        } else if (this.targetType != aType) {
            oldValue = this.targetType;
            this.targetType = aType;
            propName = "targetArrowType";
        }
        if (propName != null) {
            this.update();
            this.firePropertyChange(propName, (Object)oldValue, type);
        }
    }

    public ArrowAnnotation.AnchorType getAnchorType(ArrowAnnotation.ArrowEnd end) {
        return end == ArrowAnnotation.ArrowEnd.SOURCE ? this.sourceAnchorType : this.targetAnchorType;
    }

    public void setAnchorType(ArrowAnnotation.ArrowEnd end, ArrowAnnotation.AnchorType type) {
        String propName = null;
        ArrowAnnotation.AnchorType oldValue = null;
        if (end == ArrowAnnotation.ArrowEnd.SOURCE) {
            if (this.sourceAnchorType != type) {
                oldValue = this.sourceAnchorType;
                this.sourceAnchorType = type;
                propName = "sourceAnchorType";
            }
        } else if (this.targetAnchorType != type) {
            oldValue = this.targetAnchorType;
            this.targetAnchorType = type;
            propName = "targetAnchorType";
        }
        if (propName != null) {
            this.update();
            this.firePropertyChange(propName, oldValue, type);
        }
    }

    public Paint getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Paint color) {
        if (!Objects.equals(this.lineColor, color)) {
            Paint oldValue = this.lineColor;
            this.lineColor = color;
            this.update();
            this.firePropertyChange(ARROWCOLOR, oldValue, color);
        }
    }

    public Paint getArrowColor(ArrowAnnotation.ArrowEnd end) {
        return end == ArrowAnnotation.ArrowEnd.SOURCE ? this.sourceColor : this.targetColor;
    }

    public void setArrowColor(ArrowAnnotation.ArrowEnd end, Paint color) {
        String propName = null;
        Paint oldValue = null;
        if (end == ArrowAnnotation.ArrowEnd.SOURCE) {
            if (!Objects.equals(this.sourceColor, color)) {
                oldValue = this.sourceColor;
                this.sourceColor = color;
                propName = "sourceArrowColor";
            }
        } else if (!Objects.equals(this.targetColor, color)) {
            oldValue = this.targetColor;
            this.targetColor = color;
            propName = "targetArrowColor";
        }
        if (propName != null) {
            this.update();
            this.firePropertyChange(propName, oldValue, color);
        }
    }

    public List<String> getSupportedArrows() {
        return GraphicsUtilities.getSupportedArrowTypeNames();
    }

    @Override
    public void paint(Graphics g, boolean showSelected) {
        super.paint(g, showSelected);
        this.drawArrow(g, false);
    }

    public void drawArrow(Graphics g, boolean isPrinting) {
        if (!(this.source != null && this.target != null || this.usedForPreviews)) {
            return;
        }
        if (!this.usedForPreviews && !isPrinting) {
            this.updateBounds();
        } else {
            this.arrowLine = this.getArrowLine(this.target, this.source);
        }
        Graphics2D g2 = (Graphics2D)g;
        float border = (float)((double)this.lineWidth / 2.0);
        if (!isPrinting && border < 1.0f) {
            border = 1.0f;
        }
        g2.setPaint(this.lineColor);
        g2.setStroke(new BasicStroke(border, 1, 1, 10.0f));
        if (this.arrowLine != null) {
            if (this.lineColor instanceof Color) {
                int alpha = ((Color)this.lineColor).getAlpha();
                float opacity = (float)alpha / 255.0f;
                Composite originalComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, opacity));
                g2.draw(this.arrowLine);
                g2.setComposite(originalComposite);
            } else {
                g2.draw(this.arrowLine);
            }
        }
        g2.setStroke(new BasicStroke(border));
        if (this.sourceType != ArrowType.NONE) {
            if (this.sourceColor == null) {
                this.sourceColor = this.lineColor;
            }
            double arrowSize = this.getArrowSize(this.sourceType, this.sourceSize);
            GraphicsUtilities.drawArrow(g, this.arrowLine, ArrowAnnotation.ArrowEnd.SOURCE, this.sourceColor, arrowSize, this.sourceType);
        }
        if (this.targetType != ArrowType.NONE) {
            if (this.targetColor == null) {
                this.targetColor = this.lineColor;
            }
            double arrowSize = this.getArrowSize(this.targetType, this.targetSize);
            GraphicsUtilities.drawArrow(g, this.arrowLine, ArrowAnnotation.ArrowEnd.TARGET, this.targetColor, arrowSize, this.targetType);
        }
    }

    @Override
    public void update() {
        this.updateBounds();
        super.update();
    }

    private void updateBounds() {
        this.xOffset = 0.0;
        this.yOffset = 0.0;
        if (this.targetType != ArrowType.NONE) {
            this.xOffset = this.targetSize * 10.0 * this.getZoom() + (double)this.lineWidth;
            this.yOffset = this.targetSize * 10.0 * this.getZoom() + (double)this.lineWidth;
        }
        if (this.sourceType != ArrowType.NONE) {
            this.xOffset += this.sourceSize * 10.0 * this.getZoom() + (double)this.lineWidth;
            this.yOffset += this.sourceSize * 10.0 * this.getZoom() + (double)this.lineWidth;
        }
        if (this.source != null && this.target != null) {
            this.arrowLine = this.getArrowLine(this.target, this.source);
            if (this.arrowLine != null) {
                double x1 = this.arrowLine.getX1();
                double y1 = this.arrowLine.getY1();
                double x2 = this.arrowLine.getX2();
                double y2 = this.arrowLine.getY2();
                this.setLocation((int)(Math.min(x1, x2) - this.xOffset), (int)(Math.min(y1, y2) - this.yOffset));
                this.setSize(Math.abs(x1 - x2) + this.xOffset * 2.0, Math.abs(y1 - y2) + this.yOffset * 2.0);
            }
        }
    }

    private Line2D getArrowLine(Object target, DingAnnotation source) {
        if (this.usedForPreviews) {
            return new Line2D.Double(10.0, this.getHeight() / 2.0, this.getWidth() - 20.0, this.getHeight() / 2.0);
        }
        Point2D targetPoint = null;
        Point2D sourceCenter = ArrowAnnotationImpl.centerPoint(source.getBounds());
        if (target instanceof Point2D) {
            targetPoint = (Point2D)target;
        } else if (target instanceof DingAnnotation) {
            DingAnnotation a = (DingAnnotation)target;
            Rectangle2D targetBounds = a.getBounds();
            double arrowSize = this.getArrowSize(this.targetType, this.targetSize);
            targetPoint = ArrowAnnotationImpl.findFace(sourceCenter, targetBounds, this.targetAnchorType, this.targetType, arrowSize);
        } else if (target instanceof View) {
            View nv = (View)target;
            Rectangle2D nodeBounds = this.getNodeBounds((View<CyNode>)nv);
            double arrowSize = this.getArrowSize(this.targetType, this.targetSize);
            targetPoint = ArrowAnnotationImpl.findFace(sourceCenter, nodeBounds, this.targetAnchorType, this.targetType, arrowSize);
        }
        Rectangle2D sourceBounds = source.getBounds();
        double arrowSize = this.getArrowSize(this.sourceType, this.sourceSize);
        Point2D sourcePoint = ArrowAnnotationImpl.findFace(targetPoint, sourceBounds, this.sourceAnchorType, this.sourceType, arrowSize);
        return targetPoint != null ? new Line2D.Double(sourcePoint, targetPoint) : null;
    }

    private double getArrowSize(ArrowType type, double defaultArrowSize) {
        if (type == ArrowType.NONE) {
            return 0.0;
        }
        double factor = type == ArrowType.DIAMOND ? 5.0 : 10.0;
        return defaultArrowSize * factor * this.getZoom();
    }

    private static Point2D centerPoint(Rectangle2D bounds) {
        return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
    }

    private static Point2D findFace(Point2D source, Rectangle2D target, ArrowAnnotation.AnchorType anchorType, ArrowType arrowType, double arrowSize) {
        if (source == null || target == null) {
            return null;
        }
        double x = target.getX();
        double y = target.getY();
        double w = target.getWidth();
        double h = target.getHeight();
        if (anchorType == ArrowAnnotation.AnchorType.CENTER) {
            return new Point2D.Double(x + w / 2.0, y + h / 2.0);
        }
        if (arrowSize > 0.0 && arrowType == ArrowType.X) {
            w += arrowSize;
            h += arrowSize;
            x -= arrowSize / 2.0;
            y -= arrowSize / 2.0;
        }
        Point2D.Double left = new Point2D.Double(x, y + h / 2.0);
        Point2D.Double right = new Point2D.Double(x + w, y + h / 2.0);
        Point2D.Double top = new Point2D.Double(x + w / 2.0, y);
        Point2D.Double bottom = new Point2D.Double(x + w / 2.0, y + h);
        Line2D.Double topline = new Line2D.Double(x, y, x + w, y);
        Line2D.Double bottomline = new Line2D.Double(x, y + h, x + w, y + h);
        Line2D.Double rightline = new Line2D.Double(x + w, y, x + w, y + h);
        Line2D.Double leftline = new Line2D.Double(x, y, x, y + h);
        if (source.getX() <= x) {
            if (source.getY() == y) {
                return left;
            }
            if (source.getY() < y) {
                if (topline.ptSegDist(source) < leftline.ptSegDist(source)) {
                    return top;
                }
                return left;
            }
            if (bottomline.ptSegDist(source) < leftline.ptSegDist(source)) {
                return bottom;
            }
            return left;
        }
        if (source.getY() == y) {
            return right;
        }
        if (source.getY() < y) {
            if (topline.ptSegDist(source) < rightline.ptSegDist(source)) {
                return top;
            }
            return right;
        }
        if (bottomline.ptSegDist(source) < rightline.ptSegDist(source)) {
            return bottom;
        }
        return right;
    }

    private Rectangle2D getNodeBounds(View<CyNode> nv) {
        if (nv == null) {
            return null;
        }
        NodeDetails nodeDetails = this.re.getNodeDetails();
        double xCenter = nodeDetails.getXPosition(nv);
        double yCenter = nodeDetails.getYPosition(nv);
        double width = nodeDetails.getWidth(nv);
        double height = nodeDetails.getHeight(nv);
        double xStart = xCenter - width / 2.0;
        double yStart = yCenter - height / 2.0;
        return new Rectangle2D.Double(xStart, yStart, width, height);
    }

    public static enum ArrowType {
        CIRCLE("Circle"),
        CLOSED("Closed Arrow"),
        CONCAVE("Concave Arrow"),
        DIAMOND("Diamond"),
        OPEN("Open Arrow"),
        NONE("No Arrow"),
        X("X Arrow"),
        TRIANGLE("Triangular Head"),
        TSHAPE("T-Shape");

        private final String name;

        private ArrowType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

