/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;

public class AnnotationNode
implements MutableTreeNode {
    private Annotation annotation;
    private List<AnnotationNode> children = new ArrayList<AnnotationNode>();
    private AnnotationNode parent;

    AnnotationNode(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public AnnotationNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public AnnotationNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf((AnnotationNode)node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, (AnnotationNode)child);
    }

    @Override
    public void remove(int index) {
        this.children.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.children.remove(node);
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof String) {
            this.annotation.setName((String)object);
        } else if (object instanceof Annotation) {
            this.annotation = (Annotation)object;
        }
    }

    @Override
    public void removeFromParent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AnnotationNode[" + (this.annotation == null ? null : this.annotation.getName()) + "]";
    }

    void removeEmptyGroups() {
        for (AnnotationNode n : this.children) {
            n.removeEmptyGroups();
        }
        Iterator<AnnotationNode> iter = this.children.iterator();
        while (iter.hasNext()) {
            AnnotationNode n;
            n = iter.next();
            if (!(n.getAnnotation() instanceof GroupAnnotation) || n.getChildCount() != 0) continue;
            iter.remove();
        }
    }

    void shift(AnnotationTree.Shift shift, List<AnnotationNode> nodes) {
        nodes.retainAll(this.children);
        if (nodes.isEmpty()) {
            return;
        }
        nodes.sort(Comparator.comparing(this::getIndex));
        switch (shift) {
            case UP_ONE: {
                if (this.getIndex(nodes.get(0)) <= 0) break;
                for (AnnotationNode n : nodes) {
                    int index = this.getIndex(n);
                    this.swap(index - 1, index);
                }
                break;
            }
            case DOWN_ONE: {
                if (this.getIndex(nodes.get(nodes.size() - 1)) >= this.children.size() - 1) break;
                for (int i = nodes.size() - 1; i >= 0; --i) {
                    int index = this.getIndex(nodes.get(i));
                    this.swap(index, index + 1);
                }
                break;
            }
            case TO_FRONT: {
                ArrayList<AnnotationNode> rest = new ArrayList<AnnotationNode>(this.children);
                rest.removeIf(nodes::contains);
                this.children = new ArrayList<AnnotationNode>(this.children.size());
                nodes.forEach(this.children::add);
                rest.forEach(this.children::add);
                break;
            }
            case TO_BACK: {
                ArrayList<AnnotationNode> rest = new ArrayList<AnnotationNode>(this.children);
                rest.removeIf(nodes::contains);
                this.children = new ArrayList<AnnotationNode>(this.children.size());
                rest.forEach(this.children::add);
                nodes.forEach(this.children::add);
            }
        }
    }

    boolean shiftAllowed(AnnotationTree.Shift shift, List<AnnotationNode> nodes) {
        if (nodes.isEmpty()) {
            return false;
        }
        if (shift == AnnotationTree.Shift.TO_FRONT || shift == AnnotationTree.Shift.TO_BACK) {
            return true;
        }
        nodes.sort(Comparator.comparing(this::getIndex));
        if (shift == AnnotationTree.Shift.UP_ONE) {
            return this.getIndex(nodes.get(0)) > 0;
        }
        return this.getIndex(nodes.get(nodes.size() - 1)) < this.children.size() - 1;
    }

    private void swap(int i1, int i2) {
        if (i1 < 0 || i2 < 0) {
            return;
        }
        AnnotationNode n1 = this.children.get(i1);
        AnnotationNode n2 = this.children.get(i2);
        this.children.set(i1, n2);
        this.children.set(i2, n1);
    }

    public void add(AnnotationNode child) {
        child.parent = this;
        this.children.add(child);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void depthFirstTraversal(Visitor visitor) {
        if (this.annotation != null) {
            visitor.visit(this);
        }
        for (AnnotationNode child : this.children) {
            child.depthFirstTraversal(visitor);
        }
    }

    public List<Annotation> depthFirstOrder() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        this.depthFirstTraversal(n -> annotations.add(n.annotation));
        return annotations;
    }

    public AnnotationNode[] getPath() {
        LinkedList<AnnotationNode> list = new LinkedList<AnnotationNode>();
        for (AnnotationNode n = this; n != null; n = n.getParent()) {
            list.addFirst(n);
        }
        return list.toArray(new AnnotationNode[list.size()]);
    }

    @FunctionalInterface
    public static interface Visitor {
        public void visit(AnnotationNode var1);
    }
}

