/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.cytoscape.ding.impl.canvas.ImageGraphicsProvider;
import org.cytoscape.ding.impl.canvas.NetworkTransform;

public class NetworkImageBuffer
implements ImageGraphicsProvider {
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private NetworkTransform transform;
    private BufferedImage image;

    public NetworkImageBuffer(NetworkTransform transform) {
        this.transform = transform;
        transform.addTransformChangeListener(this::updateImage);
        this.updateImage();
    }

    private synchronized void updateImage() {
        if (this.image == null) {
            return;
        }
        if (this.transform.getPixelWidth() != this.image.getWidth(null) || this.transform.getPixelHeight() != this.image.getHeight(null)) {
            this.image = null;
        }
    }

    @Override
    public NetworkTransform getTransform() {
        return this.transform;
    }

    @Override
    public synchronized BufferedImage getImage() {
        if (this.image == null) {
            this.image = new BufferedImage(this.transform.getPixelWidth(), this.transform.getPixelHeight(), 2);
        }
        return this.image;
    }

    @Override
    public Graphics2D getGraphics(boolean clear) {
        this.image = this.getImage();
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        if (clear) {
            this.clear(g);
        }
        return g;
    }

    public void clear(Graphics2D g) {
        g.setBackground(TRANSPARENT_COLOR);
        g.clearRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
    }
}

