/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.FontMetrics;
import java.awt.Graphics;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingGraphLOD;
import org.cytoscape.ding.impl.canvas.RenderComponent;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class MainRenderComponent
extends RenderComponent {
    private FontMetrics fontMetrics;
    private boolean annotationsLoaded = false;

    public MainRenderComponent(DRenderingEngine re, DingGraphLOD lod) {
        super(re, lod);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width == this.getWidth() && height == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, width, height);
        this.re.getViewModel().batch(netView -> {
            netView.setVisualProperty(BasicVisualLexicon.NETWORK_WIDTH, (Object)width);
            netView.setVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT, (Object)height);
        }, false);
        if (!this.annotationsLoaded) {
            this.annotationsLoaded = true;
            this.re.getCyAnnotator().loadAnnotations();
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.fontMetrics == null) {
            this.fontMetrics = g.getFontMetrics();
        }
        super.update(g);
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    @Override
    protected ProgressMonitor getSlowProgressMonitor() {
        return this.re.getInputHandlerGlassPane().createProgressMonitor();
    }

    @Override
    protected void setRenderDetailFlags(RenderDetailFlags flags) {
        this.re.getPicker().setRenderDetailFlags(flags);
    }

    @Override
    DebugFrameType getDebugFrameType(DRenderingEngine.UpdateType type) {
        switch (type) {
            case ALL_FAST: {
                return DebugFrameType.MAIN_FAST;
            }
            case ALL_FULL: {
                return DebugFrameType.MAIN_SLOW;
            }
            case JUST_ANNOTATIONS: {
                return DebugFrameType.MAIN_ANNOTAITONS;
            }
            case JUST_EDGES: {
                return DebugFrameType.MAIN_EDGES;
            }
        }
        return null;
    }
}

