/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.RenderComponent;
import org.cytoscape.ding.impl.work.NoOutputProgressMonitor;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.stateful.GraphLOD;

public class BirdsEyeViewRenderComponent
extends RenderComponent {
    private static final Dimension MIN_SIZE = new Dimension(180, 180);
    private final Color VIEW_WINDOW_COLOR;
    private final Color VIEW_WINDOW_BORDER_COLOR;

    public BirdsEyeViewRenderComponent(DRenderingEngine re, GraphLOD lod) {
        super(re, lod);
        this.setPreferredSize(MIN_SIZE);
        this.setMinimumSize(MIN_SIZE);
        Color c = UIManager.getColor("Table.focusCellBackground");
        this.VIEW_WINDOW_COLOR = new Color(c.getRed(), c.getGreen(), c.getBlue(), 60);
        c = UIManager.getColor("Table.background");
        this.VIEW_WINDOW_BORDER_COLOR = new Color(c.getRed(), c.getGreen(), c.getBlue(), 90);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawRectangle(g);
    }

    private void drawRectangle(Graphics g) {
        double myXCenter = this.getTransform().getCenterX();
        double myYCenter = this.getTransform().getCenterY();
        double myScaleFactor = this.getTransform().getScaleFactor();
        double viewXCenter = this.re.getTransform().getCenterX();
        double viewYCenter = this.re.getTransform().getCenterY();
        double viewScaleFactor = this.re.getTransform().getScaleFactor();
        int viewWidth = this.re.getTransform().getWidth();
        int viewHeight = this.re.getTransform().getHeight();
        int rectWidth = (int)(myScaleFactor * ((double)viewWidth / viewScaleFactor));
        int rectHeight = (int)(myScaleFactor * ((double)viewHeight / viewScaleFactor));
        double rectXCenter = (double)this.getWidth() / 2.0 + myScaleFactor * (viewXCenter - myXCenter);
        double rectYCenter = (double)this.getHeight() / 2.0 + myScaleFactor * (viewYCenter - myYCenter);
        int x = (int)(rectXCenter - (double)(rectWidth / 2));
        int y = (int)(rectYCenter - (double)(rectHeight / 2));
        g.setColor(this.VIEW_WINDOW_COLOR);
        g.fillRect(x, y, rectWidth, rectHeight);
        g.setColor(this.VIEW_WINDOW_BORDER_COLOR);
        g.drawRect(x, y, rectWidth, rectHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    @Override
    ProgressMonitor getSlowProgressMonitor() {
        return new NoOutputProgressMonitor();
    }

    @Override
    DebugFrameType getDebugFrameType(DRenderingEngine.UpdateType type) {
        switch (type) {
            case JUST_ANNOTATIONS: {
                return DebugFrameType.BEV_ANNOTAITONS;
            }
            case ALL_FAST: {
                return DebugFrameType.BEV_FAST;
            }
            case ALL_FULL: {
                return DebugFrameType.BEV_SLOW;
            }
        }
        return null;
    }
}

