/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.application.swing.CyEdgeViewContextMenuFactory;
import org.cytoscape.application.swing.CyNetworkViewContextMenuFactory;
import org.cytoscape.application.swing.CyNodeViewContextMenuFactory;
import org.cytoscape.ding.impl.NVLTFActionSupport;
import org.cytoscape.task.EdgeViewTaskFactory;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.NodeViewTaskFactory;

public class ViewTaskFactoryListener {
    private final Map<NodeViewTaskFactory, Map<String, String>> nodeViewTFs;
    private final Map<EdgeViewTaskFactory, Map<String, String>> edgeViewTFs;
    private final Map<NetworkViewTaskFactory, Map<String, String>> emptySpaceTFs;
    private final Map<NetworkViewLocationTaskFactory, Map<String, String>> networkViewLocationTFs;
    private final Map<CyNodeViewContextMenuFactory, Map<String, String>> cyNodeViewContexMenuFactory;
    private final Map<CyEdgeViewContextMenuFactory, Map<String, String>> cyEdgeViewContextMenuFactory;
    private final Map<CyNetworkViewContextMenuFactory, Map<String, String>> cyNetworkViewContextMenuFactory;
    private final NVLTFActionSupport nvltfActionSupport;

    public ViewTaskFactoryListener(NVLTFActionSupport nvltfActionSupport) {
        this.nvltfActionSupport = nvltfActionSupport;
        this.nodeViewTFs = new ConcurrentHashMap<NodeViewTaskFactory, Map<String, String>>(16, 0.75f, 2);
        this.edgeViewTFs = new ConcurrentHashMap<EdgeViewTaskFactory, Map<String, String>>(16, 0.75f, 2);
        this.emptySpaceTFs = new ConcurrentHashMap<NetworkViewTaskFactory, Map<String, String>>(16, 0.75f, 2);
        this.networkViewLocationTFs = new ConcurrentHashMap<NetworkViewLocationTaskFactory, Map<String, String>>(16, 0.75f, 2);
        this.cyNodeViewContexMenuFactory = new ConcurrentHashMap<CyNodeViewContextMenuFactory, Map<String, String>>(16, 0.75f, 2);
        this.cyEdgeViewContextMenuFactory = new ConcurrentHashMap<CyEdgeViewContextMenuFactory, Map<String, String>>(16, 0.75f, 2);
        this.cyNetworkViewContextMenuFactory = new ConcurrentHashMap<CyNetworkViewContextMenuFactory, Map<String, String>>(16, 0.75f, 2);
    }

    public Map<NodeViewTaskFactory, Map<String, String>> getNodeViewTaskFactoryMap() {
        return this.nodeViewTFs;
    }

    public Map<EdgeViewTaskFactory, Map<String, String>> getEdgeViewTaskFactoryMap() {
        return this.edgeViewTFs;
    }

    public Map<NetworkViewTaskFactory, Map<String, String>> getEmptySpaceTaskFactoryMap() {
        return this.emptySpaceTFs;
    }

    public Map<NetworkViewLocationTaskFactory, Map<String, String>> getNetworkViewLocationTaskFactoryMap() {
        return this.networkViewLocationTFs;
    }

    public Map<CyNodeViewContextMenuFactory, Map<String, String>> getCyNodeViewContextMenuFactoryMap() {
        return this.cyNodeViewContexMenuFactory;
    }

    public Map<CyEdgeViewContextMenuFactory, Map<String, String>> getCyEdgeViewContextMenuFactoryMap() {
        return this.cyEdgeViewContextMenuFactory;
    }

    public Map<CyNetworkViewContextMenuFactory, Map<String, String>> getCyNetworkViewContextMenuFactoryMap() {
        return this.cyNetworkViewContextMenuFactory;
    }

    public void addNodeViewTaskFactory(NodeViewTaskFactory nvtf, Map<String, String> props) {
        if (nvtf != null) {
            this.nodeViewTFs.put(nvtf, props);
        }
    }

    public void removeNodeViewTaskFactory(NodeViewTaskFactory nvtf, Map<String, String> props) {
        if (nvtf != null) {
            this.nodeViewTFs.remove(nvtf);
        }
    }

    public void addEdgeViewTaskFactory(EdgeViewTaskFactory evtf, Map<String, String> props) {
        if (evtf != null) {
            this.edgeViewTFs.put(evtf, props);
        }
    }

    public void removeEdgeViewTaskFactory(EdgeViewTaskFactory evtf, Map<String, String> props) {
        if (evtf != null) {
            this.edgeViewTFs.remove(evtf);
        }
    }

    public void addNetworkViewTaskFactory(NetworkViewTaskFactory evtf, Map<String, String> props) {
        if (evtf != null) {
            this.emptySpaceTFs.put(evtf, props);
        }
    }

    public void removeNetworkViewTaskFactory(NetworkViewTaskFactory evtf, Map<String, String> props) {
        if (evtf != null) {
            this.emptySpaceTFs.remove(evtf);
        }
    }

    public void addNetworkViewLocationTaskFactory(NetworkViewLocationTaskFactory nvltf, Map<String, String> props) {
        if (nvltf != null) {
            this.networkViewLocationTFs.put(nvltf, props);
            this.nvltfActionSupport.registerAction(nvltf, props);
        }
    }

    public void removeNetworkViewLocationTaskFactory(NetworkViewLocationTaskFactory nvltf, Map<String, String> props) {
        if (nvltf != null) {
            this.networkViewLocationTFs.remove(nvltf);
        }
    }

    public void addCyNodeViewContextMenuFactory(CyNodeViewContextMenuFactory cnvcmf, Map<String, String> props) {
        if (cnvcmf != null) {
            this.cyNodeViewContexMenuFactory.put(cnvcmf, props);
        }
    }

    public void removeCyNodeViewContextMenuFactory(CyNodeViewContextMenuFactory cnvcmf, Map<String, String> props) {
        if (cnvcmf != null) {
            this.cyNodeViewContexMenuFactory.remove(cnvcmf);
        }
    }

    public void addCyEdgeViewContextMenuFactory(CyEdgeViewContextMenuFactory cevcmf, Map<String, String> props) {
        if (cevcmf != null) {
            this.cyEdgeViewContextMenuFactory.put(cevcmf, props);
        }
    }

    public void removeCyEdgeViewContextMenuFactory(CyEdgeViewContextMenuFactory cevcmf, Map<String, String> props) {
        if (cevcmf != null) {
            this.cyEdgeViewContextMenuFactory.remove(cevcmf);
        }
    }

    public void addCyNetworkViewContextMenuFactory(CyNetworkViewContextMenuFactory cnvcmf, Map<String, String> props) {
        if (cnvcmf != null) {
            this.cyNetworkViewContextMenuFactory.put(cnvcmf, props);
        }
    }

    public void removeCyNetworkViewContextMenuFactory(CyNetworkViewContextMenuFactory cnvcmf, Map<String, String> props) {
        if (cnvcmf != null) {
            this.cyNetworkViewContextMenuFactory.remove(cnvcmf);
        }
    }
}

