/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.swing.CyEdgeViewContextMenuFactory;
import org.cytoscape.application.swing.CyMenuItem;
import org.cytoscape.application.swing.CyNetworkViewContextMenuFactory;
import org.cytoscape.application.swing.CyNodeViewContextMenuFactory;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.NamedTaskFactory;
import org.cytoscape.ding.impl.StaticTaskFactoryProvisioner;
import org.cytoscape.ding.impl.ViewTaskFactoryListener;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.EdgeViewTaskFactory;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.NodeViewTaskFactory;
import org.cytoscape.util.swing.GravityTracker;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.JMenuTracker;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.Togglable;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PopupMenuHelper {
    private static final Logger logger = LoggerFactory.getLogger(PopupMenuHelper.class);
    public static final String ACTION_NEW = "NEW";
    public static final String ACTION_OPEN = "OPEN";
    private Component invoker;
    private final StaticTaskFactoryProvisioner factoryProvisioner;
    private DRenderingEngine re;
    private final ViewTaskFactoryListener vtfl;
    private final CyServiceRegistrar serviceRegistrar;

    PopupMenuHelper(DRenderingEngine re, Component inv, CyServiceRegistrar serviceRegistrar) {
        this.re = re;
        this.invoker = inv;
        this.serviceRegistrar = serviceRegistrar;
        this.vtfl = (ViewTaskFactoryListener)serviceRegistrar.getService(ViewTaskFactoryListener.class);
        this.factoryProvisioner = new StaticTaskFactoryProvisioner();
    }

    void createEdgeViewMenu(View<CyEdge> edgeView, int x, int y, String action) {
        edgeView = this.re.getViewModelSnapshot().getMutableEdgeView(edgeView.getSUID().longValue());
        if (edgeView != null) {
            Collection<EdgeViewTaskFactory> usableTFs = this.getPreferredActions(this.vtfl.getEdgeViewTaskFactoryMap(), action);
            Collection<CyEdgeViewContextMenuFactory> usableCMFs = this.getPreferredActions(this.vtfl.getCyEdgeViewContextMenuFactoryMap(), action);
            if (action.equalsIgnoreCase(ACTION_OPEN)) {
                Iterator<EdgeViewTaskFactory> i = usableTFs.iterator();
                while (i.hasNext()) {
                    if (i.next().isReady(edgeView, this.re.getViewModel())) continue;
                    i.remove();
                }
            }
            int tfCount = usableTFs.size();
            int menuItemCount = usableTFs.size() + usableCMFs.size();
            if (action.equalsIgnoreCase(ACTION_OPEN) && menuItemCount == 1 && tfCount == 1) {
                EdgeViewTaskFactory tf = usableTFs.iterator().next();
                ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(tf.createTaskIterator(edgeView, this.re.getViewModel()));
            } else {
                String edgeLabel = (String)((CyNetwork)this.re.getViewModel().getModel()).getRow((CyIdentifiable)edgeView.getModel()).get("interaction", String.class);
                JPopupMenu menu = this.createMenu(edgeLabel);
                JMenuTracker tracker = new JMenuTracker(menu);
                if (!action.equalsIgnoreCase(ACTION_OPEN)) {
                    this.initializeEdgeTracker(tracker);
                    tracker.getGravityTracker(".").addMenuSeparator(-0.1);
                    tracker.getGravityTracker(".").addMenuSeparator(999.99);
                }
                for (EdgeViewTaskFactory evtf : usableTFs) {
                    Object context = null;
                    NamedTaskFactory provisioner = this.factoryProvisioner.createFor(evtf, (View<CyEdge>)edgeView, this.re.getViewModel());
                    this.addMenuItem(edgeView, menu, provisioner, context, tracker, this.vtfl.getEdgeViewTaskFactoryMap().get(evtf));
                }
                for (CyEdgeViewContextMenuFactory edgeCMF : usableCMFs) {
                    try {
                        CyMenuItem menuItem = edgeCMF.createMenuItem(this.re.getViewModel(), edgeView);
                        this.addCyMenuItem(edgeView, menu, menuItem, tracker, this.vtfl.getCyEdgeViewContextMenuFactoryMap().get(edgeCMF));
                    }
                    catch (Throwable t) {
                        logger.error("Could not display context menu.", t);
                    }
                }
                PopupMenuHelper.sanitize(menu);
                menu.show(this.invoker, x, y);
            }
        }
    }

    void createNodeViewMenu(View<CyNode> nodeView, int x, int y, String action) {
        nodeView = this.re.getViewModelSnapshot().getMutableNodeView(nodeView.getSUID().longValue());
        if (nodeView != null) {
            Collection<NodeViewTaskFactory> usableTFs = this.getPreferredActions(this.vtfl.getNodeViewTaskFactoryMap(), action);
            Collection<CyNodeViewContextMenuFactory> usableCMFs = this.getPreferredActions(this.vtfl.getCyNodeViewContextMenuFactoryMap(), action);
            if (action.equalsIgnoreCase(ACTION_NEW)) {
                usableTFs.addAll(this.getPreferredActions(this.vtfl.getNodeViewTaskFactoryMap(), "Edge"));
                usableCMFs.addAll(this.getPreferredActions(this.vtfl.getCyNodeViewContextMenuFactoryMap(), "Edge"));
            } else if (action.equalsIgnoreCase(ACTION_OPEN)) {
                Iterator<NodeViewTaskFactory> i = usableTFs.iterator();
                while (i.hasNext()) {
                    if (i.next().isReady(nodeView, this.re.getViewModel())) continue;
                    i.remove();
                }
            }
            int menuItemCount = usableTFs.size() + usableCMFs.size();
            int tfCount = usableTFs.size();
            if ((action.equalsIgnoreCase(ACTION_OPEN) || action.equalsIgnoreCase("Edge")) && menuItemCount == 1 && tfCount == 1) {
                NodeViewTaskFactory tf = usableTFs.iterator().next();
                ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(tf.createTaskIterator(nodeView, this.re.getViewModel()));
            } else {
                String nodeLabel = (String)((CyNetwork)this.re.getViewModel().getModel()).getRow((CyIdentifiable)nodeView.getModel()).get("name", String.class);
                JPopupMenu menu = this.createMenu(nodeLabel);
                JMenuTracker tracker = new JMenuTracker(menu);
                if (!action.equalsIgnoreCase(ACTION_OPEN)) {
                    this.initializeNodeTracker(tracker);
                    tracker.getGravityTracker(".").addMenuSeparator(-0.1);
                    tracker.getGravityTracker(".").addMenuSeparator(999.99);
                }
                for (NodeViewTaskFactory nvtf : usableTFs) {
                    Object context = null;
                    NamedTaskFactory provisioner = this.factoryProvisioner.createFor(nvtf, (View<CyNode>)nodeView, this.re.getViewModel());
                    this.addMenuItem(nodeView, menu, provisioner, context, tracker, this.vtfl.getNodeViewTaskFactoryMap().get(nvtf));
                }
                for (CyNodeViewContextMenuFactory nodeCMF : usableCMFs) {
                    try {
                        CyMenuItem menuItem = nodeCMF.createMenuItem(this.re.getViewModel(), nodeView);
                        this.addCyMenuItem(nodeView, menu, menuItem, tracker, this.vtfl.getCyNodeViewContextMenuFactoryMap().get(nodeCMF));
                    }
                    catch (Throwable t) {
                        logger.error("Could not display context menu.", t);
                    }
                }
                PopupMenuHelper.sanitize(menu);
                menu.show(this.invoker, x, y);
            }
        }
    }

    void createNetworkViewMenu(Point rawPt, Point xformPt, String action) {
        Collection<NetworkViewTaskFactory> usableTFs = this.getPreferredActions(this.vtfl.getEmptySpaceTaskFactoryMap(), action);
        Collection<NetworkViewLocationTaskFactory> usableTFs2 = this.getPreferredActions(this.vtfl.getNetworkViewLocationTaskFactoryMap(), action);
        Collection<CyNetworkViewContextMenuFactory> usableCMFs = this.getPreferredActions(this.vtfl.getCyNetworkViewContextMenuFactoryMap(), action);
        CyNetworkView graphView = this.re.getViewModel();
        if (action.equalsIgnoreCase(ACTION_OPEN)) {
            Iterator<NetworkViewTaskFactory> i = usableTFs.iterator();
            while (i.hasNext()) {
                if (i.next().isReady(graphView)) continue;
                i.remove();
            }
            Iterator<NetworkViewLocationTaskFactory> i2 = usableTFs2.iterator();
            while (i2.hasNext()) {
                if (i2.next().isReady(graphView, (Point2D)rawPt, (Point2D)xformPt)) continue;
                i2.remove();
            }
        }
        int menuItemCount = usableTFs.size() + usableTFs2.size() + usableCMFs.size();
        int tfCount = usableTFs.size() + usableTFs2.size();
        if (action.equalsIgnoreCase(ACTION_OPEN) && menuItemCount == 1 && tfCount == 1) {
            DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            if (usableTFs.size() == 1) {
                NetworkViewTaskFactory tf = usableTFs.iterator().next();
                taskManager.execute(tf.createTaskIterator(graphView));
            } else if (usableTFs2.size() == 1) {
                NetworkViewLocationTaskFactory tf = usableTFs2.iterator().next();
                taskManager.execute(tf.createTaskIterator(graphView, (Point2D)rawPt, (Point2D)xformPt));
            }
        } else {
            NamedTaskFactory provisioner;
            JPopupMenu menu = this.createMenu("Double Click Menu: empty");
            JMenuTracker tracker = new JMenuTracker(menu);
            if (!action.equalsIgnoreCase(ACTION_OPEN)) {
                this.initializeNetworkTracker(tracker);
                tracker.getGravityTracker(".").addMenuSeparator(-0.1);
                tracker.getGravityTracker(".").addMenuSeparator(999.99);
            }
            for (NetworkViewTaskFactory nvtf : usableTFs) {
                provisioner = this.factoryProvisioner.createFor(nvtf, graphView);
                this.addMenuItem(null, menu, provisioner, null, tracker, this.vtfl.getEmptySpaceTaskFactoryMap().get(nvtf));
            }
            for (NetworkViewLocationTaskFactory nvltf : usableTFs2) {
                provisioner = this.factoryProvisioner.createFor(nvltf, graphView, rawPt, xformPt);
                this.addMenuItem(null, menu, provisioner, null, tracker, this.vtfl.getNetworkViewLocationTaskFactoryMap().get(nvltf));
            }
            for (CyNetworkViewContextMenuFactory netVMF : usableCMFs) {
                try {
                    CyMenuItem menuItem = netVMF.createMenuItem(graphView);
                    this.addCyMenuItem((View<?>)graphView, menu, menuItem, tracker, this.vtfl.getCyNetworkViewContextMenuFactoryMap().get(netVMF));
                }
                catch (Throwable t) {
                    logger.error("Could not display context menu.", t);
                }
            }
            PopupMenuHelper.sanitize(menu);
            menu.show(this.invoker, (int)rawPt.getX(), (int)rawPt.getY());
        }
    }

    private JPopupMenu createMenu(String title) {
        final JPopupMenu menu = new JPopupMenu(title);
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                menu.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
                menu.removeAll();
            }
        });
        return menu;
    }

    private void addMenuItem(View<?> view, JPopupMenu popup, NamedTaskFactory tf, Object tunableContext, JMenuTracker tracker, Map<?, ?> props) {
        double gravity;
        String title = (String)props.get("title");
        String pref = (String)props.get("preferredMenu");
        String toolTip = (String)props.get("tooltip");
        String menuGravity = (String)props.get("menuGravity");
        String prefAction = (String)props.get("preferredAction");
        boolean insertSepBefore = this.getBooleanProperty(props, "insertSeparatorBefore");
        boolean insertSepAfter = this.getBooleanProperty(props, "insertSeparatorAfter");
        String iconId = (String)props.get("smallIconID");
        if ("View".equalsIgnoreCase(pref)) {
            return;
        }
        double d = gravity = menuGravity != null ? Double.parseDouble(menuGravity) : -1.0;
        if (pref == null) {
            pref = prefAction != null && prefAction.equalsIgnoreCase(ACTION_OPEN) ? "." : "Apps[1]";
        }
        Icon icon = null;
        if (iconId != null && !iconId.toString().trim().isEmpty()) {
            icon = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIcon(iconId.toString());
        }
        if (title == null) {
            int last = pref.lastIndexOf(".");
            if (last > 0) {
                title = pref.substring(last + 1);
                pref = pref.substring(0, last);
                if ("Apps[1]".equals(title)) {
                    return;
                }
                GravityTracker gravityTracker = tracker.getGravityTracker(pref);
                JMenuItem item = this.createMenuItem(tf, title, toolTip, icon);
                if (insertSepBefore) {
                    gravityTracker.addMenuSeparator(gravity - 1.0E-4);
                }
                gravityTracker.addMenuItem(item, gravity);
                if (insertSepAfter) {
                    gravityTracker.addMenuSeparator(gravity + 1.0E-4);
                }
            } else {
                title = pref;
                if ("Apps[1]".equals(title)) {
                    return;
                }
                GravityTracker gravityTracker = tracker.getGravityTracker(pref);
                JMenuItem item = this.createMenuItem(tf, title, toolTip, icon);
                gravityTracker.addMenuItem(item, gravity);
            }
        } else {
            GravityTracker gravityTracker = tracker.getGravityTracker(pref);
            if (insertSepBefore) {
                gravityTracker.addMenuSeparator(gravity - 1.0E-4);
            }
            gravityTracker.addMenuItem(this.createMenuItem(tf, title, toolTip, icon), gravity);
            if (insertSepAfter) {
                gravityTracker.addMenuSeparator(gravity + 1.0E-4);
            }
        }
    }

    private void addCyMenuItem(View<?> view, JPopupMenu popup, CyMenuItem menuItem, JMenuTracker tracker, Map<?, ?> props) {
        String pref = null;
        if (props != null) {
            pref = (String)props.get("preferredMenu");
        }
        if (pref == null) {
            pref = "Apps[1]";
        }
        if (pref.equalsIgnoreCase(menuItem.getMenuItem().getText()) && menuItem.getMenuItem() instanceof JMenu) {
            GravityTracker gravityTracker = tracker.getGravityTracker(pref);
            JMenu menu = (JMenu)menuItem.getMenuItem();
            for (int menuIndex = 0; menuIndex < menu.getItemCount(); ++menuIndex) {
                JMenuItem item = menu.getItem(menuIndex);
                gravityTracker.addMenuItem(item, -1.0);
            }
            return;
        }
        GravityTracker gravityTracker = tracker.getGravityTracker(pref);
        gravityTracker.addMenuItem(menuItem.getMenuItem(), (double)menuItem.getMenuGravity());
    }

    private void initializeNetworkTracker(JMenuTracker tracker) {
        tracker.getGravityTracker("Add[-1100]");
        tracker.getGravityTracker("Delete[-1090]");
        tracker.getGravityTracker("Edit[-1080]");
        tracker.getGravityTracker("Select[-1070]");
        tracker.getGravityTracker("Group[-1060]");
        tracker.getGravityTracker("Apps[1]");
        tracker.getGravityTracker("Preferences[1000]");
    }

    private void initializeNodeTracker(JMenuTracker tracker) {
        tracker.getGravityTracker("Edit[-1100]");
        tracker.getGravityTracker("Select[-1090]");
        tracker.getGravityTracker("Group[-1080]");
        tracker.getGravityTracker("Nested Networks[-1070]");
        tracker.getGravityTracker("Apps[1]");
        tracker.getGravityTracker("External Links[1001]");
        tracker.getGravityTracker("Preferences[1100]");
    }

    private void initializeEdgeTracker(JMenuTracker tracker) {
        tracker.getGravityTracker("Edit[-1100]");
        tracker.getGravityTracker("Select[-1100]");
        tracker.getGravityTracker("Apps[1]");
        tracker.getGravityTracker("External Links[1001]");
        tracker.getGravityTracker("Preferences[1100]");
    }

    private JMenuItem createMenuItem(TaskFactory tf, String title, String toolTipText, Icon icon) {
        JMenuItem item;
        PopupAction action = new PopupAction(tf, title);
        if (tf instanceof Togglable) {
            item = new JCheckBoxMenuItem(action);
            item.setSelected(tf.isOn());
        } else {
            item = new JMenuItem(action);
        }
        boolean ready = tf.isReady();
        item.setEnabled(ready);
        action.setEnabled(ready);
        item.setToolTipText(toolTipText);
        item.setIcon(icon);
        return item;
    }

    private <T> Collection<T> getPreferredActions(Map<T, Map<String, String>> tfs, String action) {
        if (action == null) {
            return tfs.keySet();
        }
        ArrayList<T> usableTFs = new ArrayList<T>();
        for (T evtf : tfs.keySet()) {
            String prefAction = tfs.get(evtf).get("preferredAction");
            if (prefAction == null) {
                prefAction = ACTION_NEW;
            }
            if (!action.equalsIgnoreCase(prefAction)) continue;
            usableTFs.add(evtf);
        }
        return usableTFs;
    }

    private boolean getBooleanProperty(Map<?, ?> props, String property) {
        String value = (String)props.get(property);
        if (value == null || value.length() == 0) {
            return false;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void sanitize(JPopupMenu popupMenu) {
        for (Component comp : popupMenu.getComponents()) {
            if (!(comp instanceof JMenu)) continue;
            boolean hasSeparator = false;
            boolean hasMenuItem = false;
            JMenu menu = (JMenu)comp;
            int i = 0;
            for (Component mc : menu.getMenuComponents()) {
                if (mc instanceof JSeparator) {
                    if (hasSeparator || i == 0 || i == menu.getItemCount() - 1) {
                        mc.setVisible(false);
                    } else {
                        hasSeparator = true;
                    }
                } else if (mc.isVisible()) {
                    hasSeparator = false;
                    hasMenuItem = true;
                }
                ++i;
            }
            if (hasMenuItem) continue;
            comp.setEnabled(false);
        }
    }

    public void dispose() {
        this.re = null;
    }

    private class PopupAction
    extends AbstractAction {
        TaskFactory tf;

        PopupAction(TaskFactory tf, String title) {
            super(title);
            this.tf = tf;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ((DialogTaskManager)PopupMenuHelper.this.serviceRegistrar.getService(DialogTaskManager.class)).execute(this.tf.createTaskIterator());
        }
    }
}

