/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.InputHandlerGlassPane;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;

public class NVLTFActionSupport {
    private final CyServiceRegistrar registrar;

    public NVLTFActionSupport(CyServiceRegistrar registrar) {
        this.registrar = registrar;
    }

    public void registerAction(NetworkViewLocationTaskFactory nvltf, Map<String, String> props) {
        if (props.containsKey("inMenuBar") && Boolean.valueOf(props.get("inMenuBar")) == Boolean.TRUE) {
            NVLTFAction action = new NVLTFAction(nvltf, props);
            this.registrar.registerService((Object)action, CyAction.class, new Properties());
        }
    }

    TaskFactory createTaskFactory(final NetworkViewLocationTaskFactory taskFactory) {
        return new TaskFactory(){

            public boolean isReady() {
                return taskFactory.isReady(((CyApplicationManager)NVLTFActionSupport.this.registrar.getService(CyApplicationManager.class)).getCurrentNetworkView(), null, null);
            }

            public TaskIterator createTaskIterator() {
                return taskFactory.createTaskIterator(((CyApplicationManager)NVLTFActionSupport.this.registrar.getService(CyApplicationManager.class)).getCurrentNetworkView(), null, null);
            }
        };
    }

    private class NVLTFAction
    extends AbstractCyAction {
        private final NetworkViewLocationTaskFactory nvltf;

        public NVLTFAction(NetworkViewLocationTaskFactory nvltf, Map<String, String> props) {
            super(props, (CyApplicationManager)NVLTFActionSupport.this.registrar.getService(CyApplicationManager.class), (CyNetworkViewManager)NVLTFActionSupport.this.registrar.getService(CyNetworkViewManager.class), NVLTFActionSupport.this.createTaskFactory(nvltf));
            this.nvltf = nvltf;
        }

        public void actionPerformed(ActionEvent a) {
            CyNetworkView view = ((CyApplicationManager)NVLTFActionSupport.this.registrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
            DRenderingEngine re = ((DingRenderer)NVLTFActionSupport.this.registrar.getService(DingRenderer.class)).getRenderingEngine(view);
            InputHandlerGlassPane foregroundCanvas = re.getInputHandlerGlassPane();
            Point2D javaPt = foregroundCanvas.getMousePosition();
            if (javaPt == null) {
                javaPt = new Point2D.Double(0.0, 0.0);
            }
            double[] coords = new double[]{javaPt.getX(), javaPt.getY()};
            re.getTransform().xformImageToNodeCoords(coords);
            Point2D.Double xformPt = new Point2D.Double(coords[0], coords[1]);
            ((DialogTaskManager)NVLTFActionSupport.this.registrar.getService(DialogTaskManager.class)).execute(this.nvltf.createTaskIterator(view, javaPt, (Point2D)xformPt));
        }
    }
}

