/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import org.cytoscape.ding.impl.BirdsEyeView;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingNavigationRenderingEngineFactory
implements RenderingEngineFactory<CyNetwork> {
    private static final Logger logger = LoggerFactory.getLogger(DingNavigationRenderingEngineFactory.class);
    private final DingNetworkViewFactory networkViewFactory;
    private final VisualLexicon dingLexicon;
    private final CyServiceRegistrar registrar;

    public DingNavigationRenderingEngineFactory(DingNetworkViewFactory networkViewFactory, CyServiceRegistrar registrar, VisualLexicon dingLexicon) {
        this.networkViewFactory = networkViewFactory;
        this.dingLexicon = dingLexicon;
        this.registrar = registrar;
    }

    public RenderingEngine<CyNetwork> createRenderingEngine(Object visualizationContainer, View<CyNetwork> view) {
        if (visualizationContainer == null) {
            throw new IllegalArgumentException("Visualization container is null. This should be an JComponent for this rendering engine.");
        }
        if (view == null) {
            throw new IllegalArgumentException("View Model is null.");
        }
        if (!(visualizationContainer instanceof JComponent) || !(view instanceof CyNetworkView)) {
            throw new IllegalArgumentException("Visualization Container object is not of type Component, which is invalid for this implementation of PresentationFactory");
        }
        logger.debug("Start adding BEV.");
        JComponent container = (JComponent)visualizationContainer;
        DRenderingEngine re = this.networkViewFactory.getRenderingEngine((CyNetworkView)view);
        BirdsEyeView bev = new BirdsEyeView(re, this.registrar);
        container.setLayout(new BorderLayout());
        container.add((Component)bev.getComponent(), "Center");
        logger.debug("Bird's Eye View had been set to the component.  Network Model = " + ((CyNetwork)view.getModel()).getSUID());
        return bev;
    }

    public VisualLexicon getVisualLexicon() {
        return this.dingLexicon;
    }
}

