/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.BendStore;
import org.cytoscape.ding.impl.DLineType;
import org.cytoscape.ding.impl.DNodeDetails;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.HandleInfo;
import org.cytoscape.ding.impl.strokes.DAnimatedStroke;
import org.cytoscape.graph.render.immed.EdgeAnchors;
import org.cytoscape.graph.render.stateful.EdgeDetails;
import org.cytoscape.model.CyEdge;
import org.cytoscape.util.intr.LongEnumerator;
import org.cytoscape.util.intr.MinLongHeap;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.SnapshotEdgeInfo;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.EdgeStackingVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.EdgeStacking;
import org.cytoscape.view.presentation.property.values.Handle;
import org.cytoscape.view.presentation.property.values.LineType;

public final class DEdgeDetails
implements EdgeDetails {
    public static final float HANDLE_SIZE = 12.0f;
    private final DRenderingEngine re;
    private Map<View<CyEdge>, DAnimatedStroke> animatedStrokes = null;

    public DEdgeDetails(DRenderingEngine re) {
        this.re = re;
    }

    @Override
    public boolean isSelected(View<CyEdge> edgeView) {
        return Boolean.TRUE.equals(edgeView.getVisualProperty(BasicVisualLexicon.EDGE_SELECTED));
    }

    @Override
    public boolean isVisible(View<CyEdge> edgeView) {
        return Boolean.TRUE.equals(edgeView.getVisualProperty(BasicVisualLexicon.EDGE_VISIBLE));
    }

    @Override
    public Color getColorLowDetail(CyNetworkViewSnapshot netView, View<CyEdge> edgeView) {
        if (this.isSelected(edgeView)) {
            return this.getSelectedColorLowDetail(netView, edgeView);
        }
        return this.getUnselectedColorLowDetail(netView, edgeView);
    }

    private Color getUnselectedColorLowDetail(CyNetworkViewSnapshot netView, View<CyEdge> edgeView) {
        Paint paint = (Paint)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        paint = (Paint)netView.getViewDefault(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return (Color)BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT.getDefault();
    }

    private Color getSelectedColorLowDetail(CyNetworkViewSnapshot netView, View<CyEdge> edgeView) {
        Paint paint = (Paint)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        paint = (Paint)netView.getViewDefault(BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return (Color)BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT.getDefault();
    }

    @Override
    public ArrowShape getSourceArrowShape(View<CyEdge> edgeView) {
        return (ArrowShape)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_SOURCE_ARROW_SHAPE);
    }

    @Override
    public Paint getSourceArrowPaint(View<CyEdge> edgeView) {
        if (this.isSelected(edgeView)) {
            return this.getSelectedPaint(edgeView);
        }
        return this.getSourceArrowUnselectedPaint(edgeView);
    }

    private final Paint getSourceArrowUnselectedPaint(View<CyEdge> edgeView) {
        Paint paint = (Paint)edgeView.getVisualProperty(DVisualLexicon.EDGE_SOURCE_ARROW_UNSELECTED_PAINT);
        Integer trans = (Integer)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public ArrowShape getTargetArrowShape(View<CyEdge> edgeView) {
        return (ArrowShape)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE);
    }

    @Override
    public Paint getTargetArrowPaint(View<CyEdge> edgeView) {
        if (this.isSelected(edgeView)) {
            return this.getSelectedPaint(edgeView);
        }
        return this.getTargetArrowUnselectedPaint(edgeView);
    }

    private final Paint getTargetArrowUnselectedPaint(View<CyEdge> edgeView) {
        Paint paint = (Paint)edgeView.getVisualProperty(DVisualLexicon.EDGE_TARGET_ARROW_UNSELECTED_PAINT);
        Integer trans = (Integer)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public float getWidth(View<CyEdge> edgeView) {
        return ((Double)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_WIDTH)).floatValue();
    }

    private Stroke getEdgeStroke(View<CyEdge> edgeView) {
        LineType lineType = (LineType)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_LINE_TYPE);
        float width = this.getWidth(edgeView);
        return DLineType.getDLineType(lineType).getStroke(width);
    }

    @Override
    public Stroke getStroke(View<CyEdge> edgeView) {
        Stroke stroke;
        Stroke stroke2 = stroke = this.animatedStrokes == null ? null : (Stroke)this.animatedStrokes.get(edgeView);
        if (stroke == null) {
            stroke = this.getEdgeStroke(edgeView);
        }
        return stroke;
    }

    @Override
    public void updateAnimatedEdges(Collection<View<CyEdge>> edges) {
        if (edges.isEmpty()) {
            this.animatedStrokes = null;
            return;
        }
        if (this.animatedStrokes == null) {
            this.animatedStrokes = new HashMap<View<CyEdge>, DAnimatedStroke>();
        } else {
            this.animatedStrokes.keySet().retainAll(edges);
        }
        for (View<CyEdge> edge : edges) {
            DAnimatedStroke animatedStroke = this.animatedStrokes.get(edge);
            Stroke stroke = this.getEdgeStroke(edge);
            if (animatedStroke != null && DEdgeDetails.sameStroke(animatedStroke, stroke)) continue;
            this.animatedStrokes.put(edge, (DAnimatedStroke)stroke);
        }
    }

    private static boolean sameStroke(DAnimatedStroke animatedStroke, Stroke stroke) {
        return animatedStroke.getClass().equals(stroke.getClass()) && animatedStroke.getWidth() == ((DAnimatedStroke)stroke).getWidth();
    }

    @Override
    public void advanceAnimatedEdges() {
        this.animatedStrokes.replaceAll((edge, stroke) -> stroke.newInstanceForNextOffset());
    }

    @Override
    public Paint getPaint(View<CyEdge> edgeView) {
        return this.isSelected(edgeView) ? this.getSelectedPaint(edgeView) : this.getUnselectedPaint(edgeView);
    }

    @Override
    public Paint getUnselectedPaint(View<CyEdge> edgeView) {
        Paint paint = (Paint)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        if (paint == null) {
            paint = (Paint)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
        }
        Integer trans = (Integer)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public Paint getSelectedPaint(View<CyEdge> edgeView) {
        Paint paint = (Paint)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT);
        if (paint == null) {
            paint = (Paint)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_SELECTED_PAINT);
        }
        Integer trans = (Integer)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public int getLabelCount(View<CyEdge> edgeView) {
        String label = this.getLabelText(edgeView);
        return label == null || label.isEmpty() ? 0 : 1;
    }

    @Override
    public String getLabelText(View<CyEdge> edgeView) {
        return (String)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_LABEL);
    }

    @Override
    public String getTooltipText(View<CyEdge> edgeView) {
        return (String)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_TOOLTIP);
    }

    @Override
    public Font getLabelFont(View<CyEdge> edgeView) {
        Number size = (Number)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_LABEL_FONT_SIZE);
        Font font = (Font)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_LABEL_FONT_FACE);
        if (size != null && font != null) {
            font = font.deriveFont(size.floatValue());
        }
        return font;
    }

    @Override
    public Paint getLabelPaint(View<CyEdge> edgeView) {
        Paint paint = (Paint)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_LABEL_COLOR);
        Integer trans = (Integer)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_LABEL_TRANSPARENCY);
        return DNodeDetails.getTransparentColor(paint, trans);
    }

    @Override
    public EdgeStacking getStacking(View<CyEdge> edgeView) {
        return (EdgeStacking)edgeView.getVisualProperty(DVisualLexicon.EDGE_STACKING);
    }

    @Override
    public float getStackingDensity(View<CyEdge> edgeView) {
        Double radius = (Double)edgeView.getVisualProperty(DVisualLexicon.EDGE_STACKING_DENSITY);
        if (radius == null) {
            return ((Double)DVisualLexicon.EDGE_STACKING_DENSITY.getDefault()).floatValue();
        }
        float density = (float)Math.min(1.0, Math.max(0.0, radius));
        if (this.getStacking(edgeView) == EdgeStackingVisualProperty.AUTO_BEND) {
            density *= 2.0f;
        }
        return density;
    }

    @Override
    public double getLabelWidth(View<CyEdge> edgeView) {
        return (Double)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_LABEL_WIDTH);
    }

    @Override
    public Double getLabelRotation(View<CyEdge> edgeView) {
        Double dAngle = (Double)edgeView.getVisualProperty(DVisualLexicon.EDGE_LABEL_ROTATION);
        return dAngle;
    }

    @Override
    public float getSourceArrowSize(View<CyEdge> edgeView) {
        Double size = (Double)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_SOURCE_ARROW_SIZE);
        return this.adjustArrowSize(edgeView, this.getSourceArrowShape(edgeView), size);
    }

    @Override
    public float getTargetArrowSize(View<CyEdge> edgeView) {
        Double size = (Double)edgeView.getVisualProperty(BasicVisualLexicon.EDGE_TARGET_ARROW_SIZE);
        return this.adjustArrowSize(edgeView, this.getSourceArrowShape(edgeView), size);
    }

    private float adjustArrowSize(View<CyEdge> edgeView, ArrowShape arrowType, Number size) {
        if (arrowType == ArrowShapeVisualProperty.HALF_TOP || arrowType == ArrowShapeVisualProperty.HALF_BOTTOM) {
            return this.getWidth(edgeView) * size.floatValue();
        }
        return this.getWidth(edgeView) + size.floatValue();
    }

    @Override
    public Integer getLineCurved(View<CyEdge> edgeView) {
        Boolean curved = (Boolean)edgeView.getVisualProperty(DVisualLexicon.EDGE_CURVED);
        return Boolean.TRUE.equals(curved) ? 1 : 2;
    }

    @Override
    public Bend getBend(View<CyEdge> edgeView) {
        return (Bend)edgeView.getVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND);
    }

    @Override
    public float getAnchorSize(View<CyEdge> edgeView, int anchorInx) {
        if (this.isSelected(edgeView) && this.getNumAnchors(edgeView) > 0) {
            return 12.0f;
        }
        return 0.0f;
    }

    public boolean hasHandles(View<CyEdge> edgeView) {
        Bend bend = this.getBend(edgeView);
        if (bend == null) {
            return false;
        }
        return !bend.getAllHandles().isEmpty();
    }

    @Override
    public Paint getAnchorPaint(View<CyEdge> edgeView, int anchorInx) {
        if (this.getLineCurved(edgeView) == 2) {
            anchorInx /= 2;
        }
        BendStore bendStore = this.re == null ? null : this.re.getBendStore();
        Bend bend = this.getBend(edgeView);
        List handles = bend.getAllHandles();
        try {
            Handle handle = (Handle)handles.get(anchorInx);
            if (bendStore != null && bendStore.isHandleSelected(new HandleInfo(edgeView, bend, handle))) {
                return this.getSelectedPaint(edgeView);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return this.getUnselectedPaint(edgeView);
    }

    private int getNumAnchors(View<CyEdge> edgeView) {
        Bend bend = this.getBend(edgeView);
        if (bend == null) {
            return 0;
        }
        List handles = bend.getAllHandles();
        if (handles == null) {
            return 0;
        }
        int numHandles = handles.size();
        if (numHandles == 0) {
            return 0;
        }
        return this.getLineCurved(edgeView) == 1 ? numHandles : 2 * numHandles;
    }

    private void getAnchor(View<CyEdge> edgeView, int anchorIndex, float[] anchorArr) {
        if (this.re == null) {
            return;
        }
        Bend bend = this.getBend(edgeView);
        Handle handle = this.getLineCurved(edgeView) == 1 ? (Handle)bend.getAllHandles().get(anchorIndex) : (Handle)bend.getAllHandles().get(anchorIndex / 2);
        Point2D newPoint = handle.calculateHandleLocation((CyNetworkView)this.re.getViewModelSnapshot(), edgeView);
        anchorArr[0] = (float)newPoint.getX();
        anchorArr[1] = (float)newPoint.getY();
    }

    private List<View<CyEdge>> getConnectingEdgeList(CyNetworkViewSnapshot netView, long sourceSuid, long targetSuid) {
        ArrayList<View<CyEdge>> connectingEdges = new ArrayList<View<CyEdge>>();
        Iterable adjacentEdgeIterable = netView.getAdjacentEdgeIterable(sourceSuid);
        for (View edge : adjacentEdgeIterable) {
            SnapshotEdgeInfo edgeInfo = netView.getEdgeInfo(edge);
            long otherNode = sourceSuid ^ edgeInfo.getSourceViewSUID() ^ edgeInfo.getTargetViewSUID();
            if (targetSuid != otherNode) continue;
            connectingEdges.add((View<CyEdge>)edge);
        }
        return connectingEdges;
    }

    @Override
    public EdgeAnchors getAnchors(CyNetworkViewSnapshot netView, View<CyEdge> edgeView) {
        block9: {
            LongEnumerator otherEdges;
            long tmpTrgIndex;
            long tmpSrcIndex;
            long otherEdge;
            View otherEdgeView;
            long trgNodeIndex;
            if (edgeView == null) {
                return null;
            }
            if (edgeView.getVisualProperty(DVisualLexicon.EDGE_STACKING) != EdgeStackingVisualProperty.AUTO_BEND) {
                return null;
            }
            int numAnchors = this.getNumAnchors(edgeView);
            if (numAnchors > 0) {
                return new VisualPropertyEdgeAnchors(edgeView);
            }
            float[] extentsBuff = new float[4];
            SnapshotEdgeInfo edgeInfo = netView.getEdgeInfo(edgeView);
            long srcNodeIndex = edgeInfo.getSourceViewSUID();
            if (srcNodeIndex == (trgNodeIndex = edgeInfo.getTargetViewSUID())) {
                netView.getSpacialIndex2D().get((Object)srcNodeIndex, extentsBuff);
                double w = (double)extentsBuff[2] - (double)extentsBuff[0];
                double h = (double)extentsBuff[3] - (double)extentsBuff[1];
                final double x = ((double)extentsBuff[0] + (double)extentsBuff[2]) / 2.0;
                final double y = ((double)extentsBuff[1] + (double)extentsBuff[3]) / 2.0;
                final double nodeSize = Math.max(w, h);
                List<View<CyEdge>> selfEdgeList = this.getConnectingEdgeList(netView, srcNodeIndex, srcNodeIndex);
                int i = 0;
                for (View<CyEdge> selfEdge : selfEdgeList) {
                    if (selfEdge.getSUID() == edgeView.getSUID()) break;
                    if (this.getNumAnchors(selfEdge) != 0) continue;
                    ++i;
                }
                final int inx = i;
                final float densityModifier = this.getStackingDensity(edgeView);
                return new EdgeAnchors(){

                    @Override
                    public int numAnchors() {
                        return 2;
                    }

                    @Override
                    public void getAnchor(int anchorInx, float[] anchorArr) {
                        if (anchorInx == 0) {
                            anchorArr[0] = (float)(x - (double)(inx + 3) * nodeSize / 2.0 * (double)densityModifier);
                            anchorArr[1] = (float)y;
                        } else if (anchorInx == 1) {
                            anchorArr[0] = (float)x;
                            anchorArr[1] = (float)(y - (double)(inx + 3) * nodeSize / 2.0 * (double)densityModifier);
                        }
                    }
                };
            }
            do {
                MinLongHeap heap = new MinLongHeap();
                tmpSrcIndex = Math.min(srcNodeIndex, trgNodeIndex);
                tmpTrgIndex = Math.max(srcNodeIndex, trgNodeIndex);
                View tmpSrc = netView.getNodeView(tmpSrcIndex);
                View tmpTrg = netView.getNodeView(tmpTrgIndex);
                List<View<CyEdge>> conEdgeList = this.getConnectingEdgeList(netView, tmpSrc.getSUID(), tmpTrg.getSUID());
                for (View<CyEdge> conEdge : conEdgeList) {
                    heap.toss(conEdge.getSUID());
                }
                otherEdges = heap.orderedElements(false);
                otherEdge = otherEdges.nextLong();
                if (otherEdge == edgeView.getSUID()) break block9;
            } while ((otherEdgeView = netView.getEdgeView(otherEdge)) == null);
            int i = this.getNumAnchors((View<CyEdge>)otherEdgeView) == 0 ? 1 : 0;
            while (true) {
                otherEdge = otherEdges.nextLong();
                if (edgeView.getSUID() == otherEdge || otherEdge == -1L) break;
                if (this.hasHandles((View<CyEdge>)otherEdgeView)) continue;
                ++i;
            }
            int inx = i;
            netView.getSpacialIndex2D().get((Object)tmpSrcIndex, extentsBuff);
            double srcW = (double)extentsBuff[2] - (double)extentsBuff[0];
            double srcH = (double)extentsBuff[3] - (double)extentsBuff[1];
            double srcX = ((double)extentsBuff[0] + (double)extentsBuff[2]) / 2.0;
            double srcY = ((double)extentsBuff[1] + (double)extentsBuff[3]) / 2.0;
            netView.getSpacialIndex2D().get((Object)tmpTrgIndex, extentsBuff);
            double trgW = (double)extentsBuff[2] - (double)extentsBuff[0];
            double trgH = (double)extentsBuff[3] - (double)extentsBuff[1];
            double trgX = ((double)extentsBuff[0] + (double)extentsBuff[2]) / 2.0;
            double trgY = ((double)extentsBuff[1] + (double)extentsBuff[3]) / 2.0;
            double nodeSize = Math.max(Math.max(Math.max(srcW, srcH), trgW), trgH);
            double midX = (srcX + trgX) / 2.0;
            double midY = (srcY + trgY) / 2.0;
            double dx = trgX - srcX;
            double dy = trgY - srcY;
            double len = Math.sqrt(dx * dx + dy * dy);
            if ((float)len != 0.0f) {
                float densityModifier = this.getStackingDensity(edgeView);
                double offset = (double)((inx + 1) / 2 * (inx % 2 == 0 ? 1 : -1)) * nodeSize * (double)densityModifier;
                double normX = dx / len;
                double normY = dy / len;
                final double anchorX = midX + offset * normY;
                final double anchorY = midY - offset * normX;
                return new EdgeAnchors(){

                    @Override
                    public int numAnchors() {
                        return 1;
                    }

                    @Override
                    public void getAnchor(int inx, float[] arr) {
                        arr[0] = (float)anchorX;
                        arr[1] = (float)anchorY;
                    }
                };
            }
        }
        return new VisualPropertyEdgeAnchors(edgeView);
    }

    private class VisualPropertyEdgeAnchors
    implements EdgeAnchors {
        private final View<CyEdge> edgeView;

        public VisualPropertyEdgeAnchors(View<CyEdge> edgeView) {
            this.edgeView = edgeView;
        }

        @Override
        public int numAnchors() {
            return DEdgeDetails.this.getNumAnchors(this.edgeView);
        }

        @Override
        public void getAnchor(int anchorIndex, float[] anchorArr) {
            DEdgeDetails.this.getAnchor(this.edgeView, anchorIndex, anchorArr);
        }
    }
}

