/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cytoscape.ding.impl.HandleImpl;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.Handle;

public class BendImpl
implements Bend {
    private static final String DELIMITER = "|";
    private final List<Handle> handles = new CopyOnWriteArrayList<Handle>();

    public BendImpl() {
    }

    public BendImpl(BendImpl bend) {
        if (bend != null) {
            for (Handle h : bend.handles) {
                HandleImpl handle = (HandleImpl)h;
                this.handles.add(new HandleImpl(handle));
            }
        }
    }

    public List<Handle> getAllHandles() {
        return this.handles;
    }

    public void removeHandleAt(int handleIndex) {
        if (handleIndex > this.handles.size()) {
            throw new IllegalArgumentException("handleIndex is out of range: " + handleIndex);
        }
        this.handles.remove(handleIndex);
    }

    public void removeAllHandles() {
        this.handles.clear();
    }

    public int getIndex(Handle handle) {
        return this.handles.indexOf(handle);
    }

    public void insertHandleAt(int index, Handle handle) {
        this.handles.add(index, handle);
    }

    public String toString() {
        return "Handles[ " + this.handles.size() + " ]";
    }

    public String getSerializableString() {
        StringBuilder builder = new StringBuilder();
        for (Handle handle : this.handles) {
            builder.append(handle.getSerializableString() + DELIMITER);
        }
        String serialized = builder.toString();
        if (serialized.length() == 0) {
            return "";
        }
        return serialized.substring(0, serialized.length() - 1);
    }

    public static Bend parseSerializableString(String strRepresentation) {
        BendImpl bend = new BendImpl();
        if (strRepresentation == null) {
            return bend;
        }
        String[] parts = strRepresentation.split("\\|");
        for (int i = 0; i < parts.length; ++i) {
            String str = parts[i];
            Handle handle = HandleImpl.parseSerializableString(str);
            if (handle == null) continue;
            bend.insertHandleAt(i, handle);
        }
        return bend;
    }
}

