/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.icon;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.cytoscape.ding.icon.VisualPropertyIcon;

public class ArrowIcon
extends VisualPropertyIcon<Shape> {
    private static final long serialVersionUID = 1202339877462891L;
    private static final int EDGE_WIDTH = 4;
    private static final Stroke EDGE_STROKE = new BasicStroke(4.0f, 2, 0);
    protected Graphics2D g2d;

    public ArrowIcon(Shape shape, int width, int height, String name) {
        super(shape, width, height, name);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.g2d = (Graphics2D)g;
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setColor(c.getForeground());
        double x1 = x;
        double y1 = (double)y + (double)this.height / 2.0;
        double x2 = x1 + (double)this.width;
        double y2 = y1;
        if (this.value != null) {
            AffineTransform af = new AffineTransform();
            this.g2d.setStroke(new BasicStroke(2.0f));
            Shape shape = (Shape)this.value;
            double minx = shape.getBounds2D().getMinX();
            double miny = shape.getBounds2D().getMinY();
            if (minx < 0.0) {
                af.setToTranslation(Math.abs(minx), 0.0);
                shape = af.createTransformedShape(shape);
            }
            if (miny < 0.0) {
                af.setToTranslation(0.0, Math.abs(miny));
                shape = af.createTransformedShape(shape);
            }
            double shapeWidth = shape.getBounds2D().getWidth();
            double shapeHeight = shape.getBounds2D().getHeight() * 2.0;
            double originalXYRatio = shapeWidth / shapeHeight;
            double xRatio = (double)(this.width / 3) / shapeWidth;
            double yRatio = (double)this.height / shapeHeight;
            af.setToScale(xRatio * originalXYRatio, yRatio);
            shape = af.createTransformedShape(shape);
            Rectangle2D bound = shape.getBounds2D();
            af.setToTranslation(x2 - bound.getWidth(), y2 - bound.getHeight() / 2.0);
            shape = af.createTransformedShape(shape);
            this.g2d.fill(shape);
            x2 = shape.getBounds2D().getCenterX() - 2.0;
        }
        this.g2d.setStroke(EDGE_STROKE);
        this.g2d.draw(new Line2D.Double(x1, y1, x2, y2));
    }
}

