/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class NetworkViewportPanel
extends JPanel {
    private JLabel xMaxLabel;
    private JLabel xMinLabel;
    private JLabel yMaxLabel;
    private JLabel yMinLabel;
    private JLabel zoomLabel;
    private JLabel centerLabel;

    public NetworkViewportPanel() {
        this.setOpaque(false);
        this.createContents();
    }

    private void createContents() {
        this.setLayout(new BorderLayout());
        this.xMaxLabel = new JLabel();
        JPanel xMaxPanel = NetworkViewportPanel.createLabelPanel(this.xMaxLabel);
        this.xMinLabel = new JLabel();
        JPanel xMinPanel = NetworkViewportPanel.createLabelPanel(this.xMinLabel);
        this.yMaxLabel = new JLabel();
        JPanel yMaxPanel = NetworkViewportPanel.createLabelPanel(this.yMaxLabel);
        this.yMinLabel = new JLabel();
        JPanel yMinPanel = NetworkViewportPanel.createLabelPanel(this.yMinLabel);
        this.centerLabel = new JLabel();
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setOpaque(false);
        centerPanel.setPreferredSize(new Dimension(140, 100));
        JLabel filler = new JLabel(" ");
        centerPanel.add((Component)filler, "North");
        centerPanel.add((Component)NetworkViewportPanel.createLabelPanel(this.centerLabel), "Center");
        this.zoomLabel = new JLabel("");
        centerPanel.add((Component)NetworkViewportPanel.createLabelPanel(this.zoomLabel), "South");
        JPanel squarePanel = new JPanel(new GridBagLayout());
        squarePanel.setOpaque(false);
        squarePanel.add(centerPanel);
        squarePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        squarePanel.setMinimumSize(new Dimension(140, 100));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.xMaxLabel, this.xMinLabel, this.yMaxLabel, this.yMinLabel, this.centerLabel, this.zoomLabel, filler});
        this.add((Component)yMinPanel, "North");
        this.add((Component)xMinPanel, "West");
        this.add((Component)yMaxPanel, "South");
        this.add((Component)xMaxPanel, "East");
        this.add((Component)squarePanel, "Center");
    }

    private static JPanel createLabelPanel(JLabel label) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(label);
        panel.setOpaque(false);
        return panel;
    }

    public void clear() {
        this.yMinLabel.setText("");
        this.xMinLabel.setText("");
        this.yMaxLabel.setText("");
        this.xMaxLabel.setText("");
        this.zoomLabel.setText("");
        this.centerLabel.setText("");
    }

    public void updateTransform(NetworkTransform t) {
        Rectangle2D.Float b = t.getNetworkVisibleAreaNodeCoords();
        this.yMinLabel.setText(String.format("y-min: %.2f", b.getMinY()));
        this.xMinLabel.setText(String.format("x-min: %.2f ", b.getMinX()));
        this.yMaxLabel.setText(String.format("y-max: %.2f", b.getMaxY()));
        this.xMaxLabel.setText(String.format(" x-max: %.2f", b.getMaxX()));
        this.zoomLabel.setText(String.format("zoom: %.4f", t.getScaleFactor()));
        this.centerLabel.setText(String.format("(%.2f, %.2f)", t.getCenterX(), t.getCenterY()));
    }
}

