/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.cytoscape.ding.debug.DebugFrameInfo;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.debug.DebugRootFrameInfo;
import org.cytoscape.ding.debug.DebugUtil;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class FrameRatePanel
extends BasicCollapsiblePanel {
    private JLabel frameRateLabel;
    private JTable table;
    private LinkedList<DebugRootFrameInfo> frames = new LinkedList();
    private Timer timer;
    private DebugFrameInfo root;
    private int lastProcessFrameNumber = 0;
    private double lastFrameRate = 0.0;
    private final long window = 5000L;

    public FrameRatePanel() {
        super("Frame Rate");
        this.createContents();
        this.timer = new Timer(1000, e -> this.updateFrameRate());
        this.timer.setRepeats(true);
    }

    private void createContents() {
        this.frameRateLabel = new JLabel("Frame Rate: ");
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.frameRateLabel});
        this.table = new JTable();
        this.table.setShowGrid(true);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.frameRateLabel).addComponent(scrollPane, -2, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.frameRateLabel).addComponent(scrollPane));
        JPanel content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add("Center", panel);
    }

    private double calcFrameRate(int frameCount, long frameTime) {
        return (double)frameCount / ((double)frameTime / 1000.0);
    }

    private void updateFrameRateLabel(double frameRate) {
        this.frameRateLabel.setText(String.format("Frame Rate: %.2f per sec", frameRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(DebugRootFrameInfo frame) {
        LinkedList<DebugRootFrameInfo> linkedList = this.frames;
        synchronized (linkedList) {
            if (frame.getType() == DebugFrameType.MAIN_FAST && !frame.isCancelled()) {
                this.frames.addLast(frame);
            }
        }
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameRate() {
        ArrayList<DebugFrameInfo> windowFrames = new ArrayList<DebugFrameInfo>();
        LinkedList<DebugRootFrameInfo> linkedList = this.frames;
        synchronized (linkedList) {
            if (this.frames.isEmpty()) {
                return;
            }
            int currentFrameNumber = this.frames.getLast().getFrameNumber();
            if (this.lastProcessFrameNumber == 0 || currentFrameNumber != this.lastProcessFrameNumber) {
                DebugRootFrameInfo frame;
                this.lastProcessFrameNumber = currentFrameNumber;
                long endOfWindow = this.frames.getLast().getEndTime();
                long startOfWindow = endOfWindow - 5000L;
                long frameTime = 0L;
                int frameCount = 0;
                ListIterator<DebugRootFrameInfo> listIterator = this.frames.listIterator(this.frames.size());
                while (listIterator.hasPrevious() && (frame = listIterator.previous()).getStartTime() >= startOfWindow) {
                    windowFrames.add(frame);
                    frameTime += frame.getTime();
                    ++frameCount;
                }
                while (listIterator.hasPrevious()) {
                    listIterator.previous();
                    listIterator.remove();
                }
                this.root = DebugFrameInfo.merge(windowFrames);
                this.lastFrameRate = this.calcFrameRate(frameCount, frameTime);
            }
        }
        this.updateFrameRateLabel(this.lastFrameRate);
        TableModel model = this.createTabelModel(this.root);
        this.table.setModel(model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
    }

    private TableModel createTabelModel(DebugFrameInfo frame) {
        Object[] columnNames = new String[]{"Render", "Time/5000ms", "% rel", "% frame"};
        Object[][] data = this.computeFrameData(frame);
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        return model;
    }

    private Object[][] computeFrameData(DebugFrameInfo root) {
        int rows = DebugUtil.countNodesInTree(root, t -> t.getSubFrames());
        Object[][] data = new Object[rows + 1 - 1][];
        double percent = (double)(5000L - root.getTime()) / 5000.0 * 100.0;
        String percentText = String.format("%.1f", percent);
        data[0] = new Object[]{"Idle/Overhead", 5000L - root.getTime(), percentText, ""};
        this.flattenAndExtract(1, 0, root.getTime(), data, null, root);
        return data;
    }

    private int flattenAndExtract(int i, int depth, long frameTot, Object[][] data, DebugFrameInfo parent, DebugFrameInfo frame) {
        data[i] = this.getDataForRow(parent, frame, depth, frameTot);
        for (DebugFrameInfo child : frame.getSubFrames()) {
            if ("Selection".equals(child.getTask())) continue;
            ++i;
            i = this.flattenAndExtract(i, depth + 1, frameTot, data, frame, child);
        }
        return i;
    }

    private Object[] getDataForRow(DebugFrameInfo parent, DebugFrameInfo frame, int depth, long frameTot) {
        String indent = "  ".repeat(depth);
        String name = indent + frame.getTask();
        String time = indent + frame.getTime();
        double percentFrame = (double)frame.getTime() / (double)frameTot * 100.0;
        double percentRel = parent == null ? (double)frame.getTime() / 5000.0 * 100.0 : (double)frame.getTime() / (double)parent.getTime() * 100.0;
        String percentRelText = indent + String.format("%.1f", percentRel);
        String percentFrameText = indent + String.format("%.1f", percentFrame);
        return new Object[]{name, time, percentRelText, percentFrameText};
    }
}

