/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Properties;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.ding.debug.DebugProgressMonitorCallback;
import org.cytoscape.ding.debug.DebugProgressMonitorFactory;
import org.cytoscape.ding.debug.DebugRootFrameInfo;
import org.cytoscape.ding.debug.DebugRootProgressMonitor;
import org.cytoscape.ding.debug.DingDebugPanel;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.TransformChangeListener;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.events.SelectedNodesAndEdgesEvent;
import org.cytoscape.model.events.SelectedNodesAndEdgesListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.property.PropertyUpdatedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class DingDebugMediator
implements DebugProgressMonitorCallback,
TransformChangeListener,
SetCurrentNetworkViewListener,
SelectedNodesAndEdgesListener,
PropertyUpdatedListener {
    private final CyServiceRegistrar registrar;
    private final CyProperty<Properties> cyProps;
    private final DingDebugPanel debugPanel;
    private DRenderingEngine currentRE;
    private final LinkedList<DebugRootProgressMonitor> frameList = new LinkedList();

    public DingDebugMediator(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.debugPanel = new DingDebugPanel(registrar);
        this.cyProps = (CyProperty)registrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        registrar.registerService((Object)this.debugPanel, CytoPanelComponent.class, new Properties());
    }

    public static boolean showDebugPanel(CyServiceRegistrar registrar) {
        CyProperty cyProp = (CyProperty)registrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        return cyProp != null && "true".equalsIgnoreCase(((Properties)cyProp.getProperties()).getProperty("showDebugPanel"));
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        CyNetworkView netView;
        this.debugPanel.clear();
        if (this.currentRE != null) {
            this.currentRE.setDebugProgressMonitorFactory(null);
            this.currentRE.removeTransformChangeListener(this);
        }
        if ((netView = e.getNetworkView()) == null) {
            this.currentRE = null;
        } else {
            DingRenderer dingRenderer = (DingRenderer)this.registrar.getService(DingRenderer.class);
            this.currentRE = dingRenderer.getRenderingEngine(netView);
            if (this.currentRE != null) {
                this.currentRE.setDebugProgressMonitorFactory(new DebugProgressMonitorFactory(this));
                this.currentRE.addTransformChangeListener(this);
            }
        }
        this.debugPanel.setRenderingEngine(this.currentRE);
    }

    public void handleEvent(SelectedNodesAndEdgesEvent event) {
        Collection nodes = event.getSelectedNodes();
        int nodeCount = nodes.size();
        if (nodeCount == 1) {
            CyNode node = (CyNode)nodes.iterator().next();
            View nodeView = this.currentRE.getViewModel().getNodeView(node);
            if (nodeView != null) {
                Double x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                Double y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
                Double w = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
                Double h = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT);
                this.debugPanel.getNetworkInfoPanel().setSingleNode(x, y, w, h);
                return;
            }
        }
        this.debugPanel.getNetworkInfoPanel().setSelectedNodesInfo(nodeCount);
    }

    public void handleEvent(PropertyUpdatedEvent e) {
        if (Objects.equals(e.getSource(), this.cyProps)) {
            this.debugPanel.getSettingsPanel().update();
        }
    }

    @Override
    public void transformChanged() {
        this.debugPanel.getNetworkInfoPanel().updateTransform(this.currentRE.getTransform());
    }

    @Override
    public void addFrame(DebugRootFrameInfo frame) {
        this.debugPanel.getFrameListPanel().addFrame(frame);
        this.debugPanel.getFrameRatePanel().addFrame(frame);
    }
}

