/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cytoscape.ding.debug.DebugSubProgressMonitor;
import org.cytoscape.ding.debug.DebugUtil;

public class DebugFrameInfo {
    private final String task;
    private final long time;
    private final Map<String, DebugFrameInfo> subFrames;

    public DebugFrameInfo(String task, long time, List<DebugFrameInfo> subFrames) {
        this.task = task == null ? "null" : task;
        this.time = time;
        this.subFrames = new LinkedHashMap<String, DebugFrameInfo>();
        for (DebugFrameInfo sub : subFrames) {
            this.subFrames.put(sub.task, sub);
        }
    }

    public String getTask() {
        return this.task;
    }

    public String toString() {
        return this.task;
    }

    public long getTime() {
        return this.time;
    }

    public Collection<DebugFrameInfo> getSubFrames() {
        return this.subFrames.values();
    }

    public static DebugFrameInfo fromSubPM(DebugSubProgressMonitor pm) {
        String task = pm.getTaskName();
        long time = pm.getTime();
        List<DebugFrameInfo> subInfos = DebugUtil.map(pm.getSubMonitors(), x -> DebugFrameInfo.fromSubPM(x));
        return new DebugFrameInfo(task, time, subInfos);
    }

    public static DebugFrameInfo merge(DebugFrameInfo info1, DebugFrameInfo info2) {
        try {
            return DebugFrameInfo.mergeFast(info1, info2);
        }
        catch (IllegalArgumentException e) {
            return DebugFrameInfo.mergeSlow(info1, info2);
        }
    }

    private static DebugFrameInfo mergeFast(DebugFrameInfo info1, DebugFrameInfo info2) {
        if (!Objects.equals(info1.task, info2.task)) {
            throw new IllegalArgumentException("Cannot merge DebugFrameInfo, wrong tasks " + info1.task + ", " + info2.task);
        }
        if (info1.subFrames.size() != info2.subFrames.size()) {
            throw new IllegalArgumentException("Cannot merge DebugFrameInfo, not same number of tasks " + info1.subFrames.keySet() + "..." + info2.subFrames.keySet());
        }
        List<DebugFrameInfo> mergedSubFrames = DebugUtil.map2(info1.subFrames.values(), info2.subFrames.values(), DebugFrameInfo::mergeFast);
        return new DebugFrameInfo(info1.task, info1.time + info2.time, mergedSubFrames);
    }

    public static DebugFrameInfo mergeSlow(DebugFrameInfo info1, DebugFrameInfo info2) {
        if (!Objects.equals(info1.task, info2.task)) {
            throw new IllegalArgumentException("Cannot merge DebugFrameInfo, wrong tasks " + info1.task + ", " + info2.task);
        }
        LinkedHashSet<String> tasks = new LinkedHashSet<String>();
        tasks.addAll(info1.subFrames.keySet());
        tasks.addAll(info2.subFrames.keySet());
        ArrayList<DebugFrameInfo> mergedSubFrames = new ArrayList<DebugFrameInfo>(tasks.size());
        for (String task : tasks) {
            DebugFrameInfo sub1 = info1.subFrames.get(task);
            DebugFrameInfo sub2 = info2.subFrames.get(task);
            if (sub1 != null && sub2 != null) {
                mergedSubFrames.add(DebugFrameInfo.mergeSlow(sub1, sub2));
                continue;
            }
            if (sub2 == null) {
                mergedSubFrames.add(sub1);
                continue;
            }
            if (sub1 != null) continue;
            mergedSubFrames.add(sub2);
        }
        return new DebugFrameInfo(info1.task, info1.time + info2.time, mergedSubFrames);
    }

    public static DebugFrameInfo merge(List<DebugFrameInfo> list) {
        return DebugUtil.reduce(list, DebugFrameInfo::merge);
    }
}

