/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsiMiTabCyFileFilter
implements CyFileFilter {
    private final Set<String> extensions = new HashSet<String>();
    private final String description;
    private final Set<String> contentTypes;

    public PsiMiTabCyFileFilter() {
        this.extensions.add("mitab");
        this.contentTypes = new HashSet<String>();
        this.contentTypes.add("text/psi-mi-tab");
        this.description = "PSI-MI TAB 2.5 file";
    }

    public boolean accepts(URI uri, DataCategory category) {
        if (!category.equals((Object)DataCategory.NETWORK)) {
            return false;
        }
        String ext = CommonsIOFilenameUtils.getExtension(uri.toString());
        return this.extensions.contains(ext);
    }

    public boolean accepts(InputStream stream, DataCategory category) {
        if (!category.equals((Object)DataCategory.NETWORK)) {
            return false;
        }
        try {
            return this.checkFirstLine(stream);
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Error while checking header", (Throwable)e);
            return false;
        }
    }

    private boolean checkFirstLine(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8").newDecoder()));
        String line = reader.readLine();
        if (line != null) {
            String[] parts = line.split("\t");
            return parts.length >= 15;
        }
        return false;
    }

    public Set<String> getExtensions() {
        return this.extensions;
    }

    public Set<String> getContentTypes() {
        return this.contentTypes;
    }

    public String getDescription() {
        return this.description;
    }

    public DataCategory getDataCategory() {
        return DataCategory.NETWORK;
    }

    private static final class CommonsIOFilenameUtils {
        public static final char EXTENSION_SEPARATOR = '.';
        private static final char UNIX_SEPARATOR = '/';
        private static final char WINDOWS_SEPARATOR = '\\';

        private CommonsIOFilenameUtils() {
        }

        public static String getExtension(String filename) {
            if (filename == null) {
                return null;
            }
            int index = CommonsIOFilenameUtils.indexOfExtension(filename);
            if (index == -1) {
                return "";
            }
            return filename.substring(index + 1);
        }

        public static int indexOfExtension(String filename) {
            if (filename == null) {
                return -1;
            }
            int extensionPos = filename.lastIndexOf(46);
            int lastSeparator = CommonsIOFilenameUtils.indexOfLastSeparator(filename);
            return lastSeparator > extensionPos ? -1 : extensionPos;
        }

        public static int indexOfLastSeparator(String filename) {
            if (filename == null) {
                return -1;
            }
            int lastUnixPos = filename.lastIndexOf(47);
            int lastWindowsPos = filename.lastIndexOf(92);
            return Math.max(lastUnixPos, lastWindowsPos);
        }
    }
}

