/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.io.InputStream;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.psi_mi.internal.data_mapper.PSIMI25EntryMapper;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.model.EntrySet;

public class PSIMI25XMLNetworkViewReader
extends AbstractCyNetworkReader {
    private static final Logger logger = LoggerFactory.getLogger(PSIMI25XMLNetworkViewReader.class);
    private CyLayoutAlgorithmManager layouts;
    private TaskMonitor parentTaskMonitor;
    private PSIMI25EntryMapper mapper;

    public PSIMI25XMLNetworkViewReader(InputStream inputStream, CyApplicationManager applicationManager, CyNetworkFactory networkFactory, CyNetworkViewFactory networkViewFactory, CyLayoutAlgorithmManager layouts, CyNetworkManager networkManager, CyRootNetworkManager rootNetworkManager) {
        super(inputStream, applicationManager, networkFactory, networkManager, rootNetworkManager);
        this.layouts = layouts;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.parentTaskMonitor = taskMonitor;
        long start = System.currentTimeMillis();
        taskMonitor.setProgress(0.01);
        taskMonitor.setTitle("Loading PSI-MI 2.5.x XML File ");
        taskMonitor.setStatusMessage("Loading data file in PSI-MI 2.5 XML format.");
        PsimiXmlReader reader = new PsimiXmlReader();
        EntrySet result = reader.read(this.inputStream);
        taskMonitor.setProgress(0.4);
        taskMonitor.setStatusMessage("Data Loaded.  Mapping Data to Network...");
        if (this.cancelled) {
            this.inputStream.close();
            return;
        }
        CyRootNetwork root = this.getRootNetwork();
        CySubNetwork newNetwork = root != null ? root.addSubNetwork() : (CySubNetwork)this.cyNetworkFactory.createNetwork();
        this.mapper = new PSIMI25EntryMapper((CyNetwork)newNetwork, result);
        this.mapper.map();
        this.networks = new CyNetwork[]{newNetwork};
        taskMonitor.setProgress(1.0);
        logger.info("PSI-MI XML Data Import finihsed in " + (System.currentTimeMillis() - start) + " msec.");
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view = this.getNetworkViewFactory().createNetworkView(network);
        CyLayoutAlgorithm layout = this.layouts.getDefaultLayout();
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, "");
        Task nextTask = itr.next();
        try {
            nextTask.run(this.parentTaskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        this.parentTaskMonitor.setProgress(1.0);
        return view;
    }

    public void cancel() {
        super.cancel();
        this.mapper.cancel();
    }
}

