/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.psi_mi.internal.cyto_mapper.MapToCytoscape;
import org.cytoscape.psi_mi.internal.data_mapper.MapPsiOneToInteractions;
import org.cytoscape.psi_mi.internal.model.Interaction;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSIMI10XMLNetworkViewReader
extends AbstractCyNetworkReader {
    private static final Logger logger = LoggerFactory.getLogger(PSIMI10XMLNetworkViewReader.class);
    private static final int BUFFER_SIZE = 16384;
    private CyLayoutAlgorithmManager layouts;
    private TaskMonitor parentTaskMonitor;

    public PSIMI10XMLNetworkViewReader(InputStream inputStream, CyApplicationManager applicationManager, CyNetworkFactory networkFactory, CyNetworkViewFactory networkViewFactory, CyLayoutAlgorithmManager layouts, CyNetworkManager networkManager, CyRootNetworkManager rootNetworkManager) {
        super(inputStream, applicationManager, networkFactory, networkManager, rootNetworkManager);
        this.layouts = layouts;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.parentTaskMonitor = taskMonitor;
        long start = System.currentTimeMillis();
        taskMonitor.setStatusMessage("Loading PSI-MI 1.x XML file...");
        taskMonitor.setProgress(0.05);
        String xml = PSIMI10XMLNetworkViewReader.readString(this.inputStream);
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        MapPsiOneToInteractions mapper1 = new MapPsiOneToInteractions(xml, interactions);
        mapper1.doMapping();
        taskMonitor.setProgress(0.4);
        if (this.cancelled) {
            this.inputStream.close();
            return;
        }
        CyRootNetwork root = this.getRootNetwork();
        CySubNetwork newNetwork = root != null ? root.addSubNetwork() : (CySubNetwork)this.cyNetworkFactory.createNetwork();
        MapToCytoscape mapper2 = new MapToCytoscape((CyNetwork)newNetwork, interactions, 1);
        mapper2.doMapping();
        this.networks = new CyNetwork[]{newNetwork};
        taskMonitor.setProgress(1.0);
        logger.info("PSI-MI XML Data Import finihsed in " + (System.currentTimeMillis() - start) + " msec.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(InputStream source) throws IOException {
        StringWriter writer = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source, Charset.forName("UTF-8").newDecoder()));){
            char[] buffer = new char[16384];
            int charactersRead = reader.read(buffer, 0, buffer.length);
            while (charactersRead != -1) {
                writer.write(buffer, 0, charactersRead);
                charactersRead = reader.read(buffer, 0, buffer.length);
            }
        }
        return writer.toString();
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view = this.getNetworkViewFactory().createNetworkView(network);
        CyLayoutAlgorithm layout = this.layouts.getDefaultLayout();
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, "");
        Task nextTask = itr.next();
        try {
            nextTask.run(this.parentTaskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        this.parentTaskMonitor.setProgress(1.0);
        return view;
    }
}

