/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cmdline.gui.internal;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.cytoscape.application.CyShutdown;
import org.cytoscape.application.CyVersion;
import org.cytoscape.cmdline.gui.internal.StartupConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final String[] args;
    private final Options options;
    private final CyShutdown shutdown;
    private final CyVersion version;
    private final StartupConfig startupConfig;
    private final Properties props;

    public Parser(String[] args, CyShutdown shutdown, CyVersion version, StartupConfig startupConfig, Properties props) {
        this.args = args;
        this.shutdown = shutdown;
        this.version = version;
        this.startupConfig = startupConfig;
        this.props = props;
        this.options = this.initOptions();
        this.parseCommandLine(args);
    }

    private Options initOptions() {
        Options opt = new Options();
        opt.addOption("h", "help", false, "Print this message.");
        opt.addOption("v", "version", false, "Print the version number.");
        OptionBuilder.withLongOpt((String)"session");
        OptionBuilder.withDescription((String)"Load a cytoscape session (.cys) file.");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        opt.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"network");
        OptionBuilder.withDescription((String)"Load a network file (any format).");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        opt.addOption(OptionBuilder.create((String)"N"));
        OptionBuilder.withLongOpt((String)"props");
        OptionBuilder.withDescription((String)"Load cytoscape properties file (Java properties format) or individual property: -P name=value.");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        opt.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withLongOpt((String)"vizmap");
        OptionBuilder.withDescription((String)"Load vizmap properties file (Cytoscape VizMap format).");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        opt.addOption(OptionBuilder.create((String)"V"));
        OptionBuilder.withLongOpt((String)"script");
        OptionBuilder.withDescription((String)"Execute commands from script file");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        opt.addOption(OptionBuilder.create((String)"S"));
        OptionBuilder.withLongOpt((String)"rest");
        OptionBuilder.withDescription((String)"Start a rest service");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArgs();
        opt.addOption(OptionBuilder.create((String)"R"));
        return opt;
    }

    private void parseCommandLine(String[] args) {
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            logger.error("Parsing command line failed: " + e.getMessage());
            this.printHelp();
            this.props.setProperty("tempHideWelcomeScreen", "true");
            this.shutdown.exit(1);
            return;
        }
        if (line.hasOption("h")) {
            this.printHelp();
            this.shutdown.exit(0);
            this.props.setProperty("tempHideWelcomeScreen", "true");
            return;
        }
        if (line.hasOption("v")) {
            logger.info("Cytoscape version: " + this.version.getVersion());
            System.out.println("Cytoscape version: " + this.version.getVersion());
            this.props.setProperty("tempHideWelcomeScreen", "true");
            this.shutdown.exit(0);
            return;
        }
        if (line.hasOption("P")) {
            this.startupConfig.setProperties(line.getOptionValues("P"));
        }
        if (line.getOptions().length == 0 && line.getArgs().length == 1 && line.getArgs()[0].endsWith(".cys")) {
            this.startupConfig.setSession(line.getArgs()[0]);
            return;
        }
        if (line.hasOption("s")) {
            this.startupConfig.setSession(line.getOptionValue("s"));
        } else {
            if (line.hasOption("N")) {
                this.startupConfig.setNetworks(line.getOptionValues("N"));
            }
            if (line.hasOption("V")) {
                this.startupConfig.setVizMapProps(line.getOptionValues("V"));
            }
        }
        if (line.hasOption("S")) {
            this.startupConfig.setCommandScript(line.getOptionValue("S"));
        }
        if (line.hasOption("R")) {
            this.startupConfig.setRestPort(line.getOptionValue("R"));
        }
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("cytoscape.{sh|bat} [OPTIONS]", this.options);
    }
}

