/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal.column;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.model.internal.column.CanonicalStringPool;
import org.cytoscape.model.internal.column.CanonicalStringPoolFilter;
import org.cytoscape.model.internal.column.ColumnData;
import org.cytoscape.model.internal.column.ColumnDataFactory;
import org.cytoscape.model.internal.column.MapColumn;

public class ColumnDataFactoryHashMapWithStringPool
implements ColumnDataFactory {
    private final CanonicalStringPool stringPool = new CanonicalStringPool();

    @Override
    public void clearCache() {
        this.stringPool.clear();
    }

    @Override
    public ColumnData create(Class<?> primaryKeyType, Class<?> type, Class<?> listElementType, int defaultInitSize) {
        if (String.class.equals(type)) {
            return new CanonicalStringPoolFilter(this.stringPool, new MapColumn(new HashMap<Object, Object>(defaultInitSize)));
        }
        return new MapColumn(new HashMap<Object, Object>(defaultInitSize));
    }

    @Override
    public List<?> createList(Class<?> elementType, List<?> data) {
        if (String.class.equals(elementType)) {
            ArrayList canonData = new ArrayList(data.size());
            for (Object value : data) {
                if (value instanceof String) {
                    value = this.stringPool.canonicalize((String)value);
                }
                canonData.add(value);
            }
            return canonData;
        }
        return new ArrayList(data);
    }
}

