/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.events.SelectedNodesAndEdgesEvent;
import org.cytoscape.model.events.SelectedNodesAndEdgesListener;
import org.cytoscape.service.util.CyServiceRegistrar;

public class SelectionMediator
implements RowsSetListener {
    private final CyServiceRegistrar serviceRegistrar;
    private CyNetworkTableManager networkTableManager;
    private CyApplicationManager applicationManager;
    private CyEventHelper eventHelper;
    private boolean fireSelectionEvents = false;
    private DebounceTimer debounceTimer;

    public SelectionMediator(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(RowsSetEvent e) {
        if (!this.fireSelectionEvents) {
            return;
        }
        if (!e.containsColumn("selected")) {
            return;
        }
        if (this.debounceTimer == null) {
            this.debounceTimer = new DebounceTimer(100);
        }
        CyTable source = (CyTable)e.getSource();
        CyNetwork network = this.getNetworkTableManager().getNetworkForTable(source);
        if (network == null) {
            return;
        }
        CyNetwork currentNetwork = this.getApplicationManager().getCurrentNetwork();
        boolean isCurrent = network.equals(currentNetwork);
        CyEventHelper eventHelper = this.getEventHelper();
        if (source == network.getDefaultNodeTable()) {
            this.debounceTimer.debounce((Object)"nodes", () -> eventHelper.fireEvent((CyEvent)new SelectedNodesAndEdgesEvent(network, isCurrent, true, false)));
        } else if (source == network.getDefaultEdgeTable()) {
            this.debounceTimer.debounce((Object)"edges", () -> eventHelper.fireEvent((CyEvent)new SelectedNodesAndEdgesEvent(network, isCurrent, false, true)));
        }
    }

    private CyNetworkTableManager getNetworkTableManager() {
        if (this.networkTableManager == null) {
            this.networkTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        }
        return this.networkTableManager;
    }

    private CyApplicationManager getApplicationManager() {
        if (this.applicationManager == null) {
            this.applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        }
        return this.applicationManager;
    }

    private CyEventHelper getEventHelper() {
        if (this.eventHelper == null) {
            this.eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        }
        return this.eventHelper;
    }

    public void listenerAdded(SelectedNodesAndEdgesListener listener, Map<String, String> args) {
        this.fireSelectionEvents = true;
    }

    public void listenerRemoved(SelectedNodesAndEdgesListener listener, Map<String, String> args) {
    }
}

