/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class RemovedAttributesCache {
    private final String[] namespaces = new String[]{"USER", "SHARED_ATTRS", "HIDDEN"};
    private final WeakHashMap<CyIdentifiable, AttributesCache> cachedElements = new WeakHashMap();
    private final CyNetwork network;

    public RemovedAttributesCache(CyNetwork network) {
        this.network = network;
    }

    public void cache(Collection<? extends CyIdentifiable> elements) {
        for (CyIdentifiable cyIdentifiable : elements) {
            AttributesCache attributesCache = new AttributesCache();
            for (String namespace : this.namespaces) {
                attributesCache.put(namespace, this.network.getRow(cyIdentifiable, namespace));
            }
            this.cachedElements.put(cyIdentifiable, attributesCache);
        }
    }

    public void restore(CyIdentifiable element) {
        AttributesCache attributesCache = this.cachedElements.remove(element);
        if (attributesCache != null) {
            for (String namespace : this.namespaces) {
                CyRow cachedRow = attributesCache.get(namespace);
                Map attributes = cachedRow.getAllValues();
                CyRow realRow = this.getRow(element, namespace);
                if (realRow == null) continue;
                for (Map.Entry attribute : attributes.entrySet()) {
                    realRow.set((String)attribute.getKey(), attribute.getValue());
                }
            }
        }
    }

    private CyRow getRow(CyIdentifiable element, String namespace) {
        CyTable table = null;
        if (element instanceof CyNode) {
            table = this.network.getTable(CyNode.class, namespace);
        } else if (element instanceof CyEdge) {
            table = this.network.getTable(CyEdge.class, namespace);
        }
        return table == null ? null : table.getRow((Object)element.getSUID());
    }

    public void evict(CyIdentifiable element) {
        this.cachedElements.remove(element);
    }

    public void dispose() {
        this.cachedElements.clear();
    }

    public boolean contains(CyIdentifiable elemement) {
        return this.cachedElements.containsKey(elemement);
    }

    public CyRow getAttributes(CyIdentifiable element, String namespace) {
        AttributesCache attributesCache = this.cachedElements.get(element);
        if (attributesCache != null) {
            return attributesCache.get(namespace);
        }
        return null;
    }

    public int size() {
        return this.cachedElements.size();
    }

    public String toString() {
        long nodeCount = this.cachedElements.keySet().stream().filter(x -> CyNode.class.isAssignableFrom(x.getClass())).count();
        long edgeCount = this.cachedElements.keySet().stream().filter(x -> CyEdge.class.isAssignableFrom(x.getClass())).count();
        return "RemovedAttributesCache[nodes=" + nodeCount + ", edges=" + edgeCount + "]";
    }

    public static class AttributesCache {
        private Map<String, CachedRow> allAttributes = new HashMap<String, CachedRow>();

        AttributesCache() {
        }

        void put(String namespace, CyRow row) {
            this.allAttributes.put(namespace, new CachedRow(row));
        }

        CyRow get(String namespace) {
            return this.allAttributes.get(namespace);
        }
    }

    private static class CachedRow
    implements CyRow {
        private final Map<String, Object> values;
        private final Long suid;

        public CachedRow(CyRow row) {
            this.suid = row.getSUID();
            this.values = new HashMap<String, Object>(row.getAllValues());
        }

        public Long getSUID() {
            return this.suid;
        }

        public <T> T get(String columnName, Class<? extends T> type) {
            return type.cast(this.values.get(columnName));
        }

        public <T> T get(String columnName, Class<? extends T> type, T defaultValue) {
            return type.cast(this.values.getOrDefault(columnName, defaultValue));
        }

        public <T> List<T> getList(String columnName, Class<T> listElementType) {
            return (List)this.values.get(columnName);
        }

        public <T> List<T> getList(String columnName, Class<T> listElementType, List<T> defaultValue) {
            return this.values.getOrDefault(columnName, defaultValue);
        }

        public <T> void set(String columnName, T value) {
            throw new UnsupportedOperationException();
        }

        public boolean isSet(String columnName) {
            return this.values.containsKey(columnName);
        }

        public Map<String, Object> getAllValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public Object getRaw(String columnName) {
            return this.values.get(columnName);
        }

        public CyTable getTable() {
            throw new UnsupportedOperationException();
        }
    }
}

