/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.List;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.internal.AbstractTableFacade;
import org.cytoscape.model.internal.SharedTableFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalTableFacade
extends AbstractTableFacade
implements CyTable {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final SharedTableFacade shared;
    private final CyTable local;

    public LocalTableFacade(CyTable local, SharedTableFacade shared, CyEventHelper eventHelper) {
        super(local, eventHelper);
        this.local = local;
        this.shared = shared;
        for (CyColumn col : shared.getActualTable().getColumns()) {
            String columnName = col.getName();
            if (columnName.equalsIgnoreCase("SUID") || columnName.equalsIgnoreCase("name") || columnName.equalsIgnoreCase("selected")) continue;
            local.addVirtualColumn(columnName, columnName, shared.getActualTable(), "SUID", col.isImmutable());
        }
    }

    CyTable getLocalTable() {
        return this.local;
    }

    public void deleteColumn(String columnName) {
        if (this.shared.getColumn(columnName) != null) {
            this.shared.deleteColumn(columnName);
        } else {
            this.local.deleteColumn(columnName);
        }
    }

    public <T> void createColumn(String columnName, Class<? extends T> type, boolean isImmutable) {
        this.createColumn(columnName, type, isImmutable, null);
    }

    public <T> void createColumn(String columnName, Class<? extends T> type, boolean isImmutable, T defaultValue) {
        CyColumn col = this.shared.getColumn(columnName);
        if (col == null) {
            logger.debug("delegating createColumn '" + columnName + "' from local " + this.local.getTitle() + " to shared: " + this.shared.getTitle() + ": " + type.getName() + " " + isImmutable);
            this.shared.createColumn(columnName, type, isImmutable, defaultValue);
        } else {
            this.local.addVirtualColumn(columnName, columnName, this.shared.getActualTable(), "SUID", isImmutable);
        }
    }

    public <T> void createListColumn(String columnName, Class<T> listElementType, boolean isImmutable) {
        this.createListColumn(columnName, listElementType, isImmutable, null);
    }

    public <T> void createListColumn(String columnName, Class<T> listElementType, boolean isImmutable, List<T> defaultValue) {
        logger.debug("delegating create List Column '" + columnName + "' from local " + this.local.getTitle() + " to shared: " + this.shared.getTitle());
        this.shared.createListColumn(columnName, listElementType, isImmutable, defaultValue);
    }

    public String addVirtualColumn(String virtualColumn, String sourceColumn, CyTable sourceTable, String targetJoinKey, boolean isImmutable) {
        if (this.shared.getColumn(targetJoinKey) != null) {
            return this.shared.addVirtualColumn(virtualColumn, sourceColumn, sourceTable, targetJoinKey, isImmutable);
        }
        return this.local.addVirtualColumn(virtualColumn, sourceColumn, sourceTable, targetJoinKey, isImmutable);
    }

    public void addVirtualColumns(CyTable sourceTable, String targetJoinKey, boolean isImmutable) {
        if (this.shared.getColumn(targetJoinKey) != null) {
            this.shared.addVirtualColumns(sourceTable, targetJoinKey, isImmutable);
        } else {
            this.local.addVirtualColumns(sourceTable, targetJoinKey, isImmutable);
        }
    }

    @Override
    protected void updateColumnName(String oldName, String newName) {
        if (this.shared.getColumn(oldName) != null) {
            this.shared.getColumn(oldName).setName(newName);
        } else {
            this.local.getColumn(oldName).setName(newName);
        }
    }
}

