/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import org.cytoscape.model.CyEdge;
import org.cytoscape.model.internal.NodePointer;

final class EdgePointer {
    final CyEdge cyEdge;
    final long index;
    final boolean directed;
    final NodePointer source;
    final NodePointer target;
    EdgePointer nextOutEdge;
    EdgePointer prevOutEdge;
    EdgePointer nextInEdge;
    EdgePointer prevInEdge;

    EdgePointer(NodePointer s, NodePointer t, boolean dir, CyEdge edge) {
        this.source = s;
        this.target = t;
        this.directed = dir;
        this.cyEdge = edge;
        this.index = edge.getSUID();
        this.nextOutEdge = null;
        this.prevOutEdge = null;
        this.nextInEdge = null;
        this.prevInEdge = null;
        this.insertSelf();
    }

    private void insertSelf() {
        this.nextOutEdge = this.source.firstOutEdge;
        if (this.source.firstOutEdge != null) {
            this.source.firstOutEdge.prevOutEdge = this;
        }
        this.source.firstOutEdge = this;
        this.nextInEdge = this.target.firstInEdge;
        if (this.target.firstInEdge != null) {
            this.target.firstInEdge.prevInEdge = this;
        }
        this.target.firstInEdge = this;
        if (this.directed) {
            ++this.source.outDegree;
            ++this.target.inDegree;
        } else {
            ++this.source.undDegree;
            ++this.target.undDegree;
        }
        if (this.source == this.target) {
            ++this.source.selfEdges;
        }
    }

    void remove() {
        if (this.prevOutEdge != null) {
            this.prevOutEdge.nextOutEdge = this.nextOutEdge;
        } else {
            this.source.firstOutEdge = this.nextOutEdge;
        }
        if (this.nextOutEdge != null) {
            this.nextOutEdge.prevOutEdge = this.prevOutEdge;
        }
        if (this.prevInEdge != null) {
            this.prevInEdge.nextInEdge = this.nextInEdge;
        } else {
            this.target.firstInEdge = this.nextInEdge;
        }
        if (this.nextInEdge != null) {
            this.nextInEdge.prevInEdge = this.prevInEdge;
        }
        if (this.directed) {
            --this.source.outDegree;
            --this.target.inDegree;
        } else {
            --this.source.undDegree;
            --this.target.undDegree;
        }
        if (this.source == this.target) {
            --this.source.selfEdges;
        }
        this.nextOutEdge = null;
        this.prevOutEdge = null;
        this.nextInEdge = null;
        this.prevInEdge = null;
    }
}

