/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.equations.EquationUtil;
import org.cytoscape.equations.event.EquationFunctionAddedEvent;
import org.cytoscape.equations.event.EquationFunctionAddedListener;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.TableAboutToBeDeletedEvent;
import org.cytoscape.model.events.TableAddedEvent;
import org.cytoscape.model.events.TableDeletedEvent;
import org.cytoscape.model.internal.CyTableImpl;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyTableManagerImpl
implements CyTableManager,
NetworkAboutToBeDestroyedListener,
EquationFunctionAddedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final Class<? extends CyIdentifiable>[] COMPATIBLE_TYPES = new Class[]{CyNetwork.class, CyNode.class, CyEdge.class};
    private final CyNetworkTableManager networkTableManager;
    private final CyNetworkManager networkManager;
    private final CyServiceRegistrar serviceRegistrar;
    private final Map<Long, CyTable> tables;
    private final Object lock = new Object();

    public CyTableManagerImpl(CyNetworkTableManager networkTableManager, CyNetworkManager networkManager, CyServiceRegistrar serviceRegistrar) {
        if (networkTableManager == null) {
            throw new IllegalArgumentException("networkTableManager must not be null.");
        }
        if (networkManager == null) {
            throw new IllegalArgumentException("networkManager must not be null.");
        }
        if (serviceRegistrar == null) {
            throw new IllegalArgumentException("serviceRegistrar must not be null.");
        }
        this.networkTableManager = networkTableManager;
        this.networkManager = networkManager;
        this.serviceRegistrar = serviceRegistrar;
        this.tables = new HashMap<Long, CyTable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Collection<CyTable> values;
        Object object = this.lock;
        synchronized (object) {
            values = this.tables.values();
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        for (CyTable table : values) {
            eventHelper.fireEvent((CyEvent)new TableAboutToBeDeletedEvent((CyTableManager)this, table));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.tables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTable(CyTable t) {
        boolean fireEvent = false;
        Object object = this.lock;
        synchronized (object) {
            if (t == null) {
                throw new NullPointerException("added table is null");
            }
            Long suid = t.getSUID();
            if (this.tables.get(suid) == null) {
                this.tables.put(suid, t);
                fireEvent = true;
            }
        }
        if (fireEvent) {
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.fireEvent((CyEvent)new TableAddedEvent((CyTableManager)this, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyTable> getAllTables(boolean includePrivate) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<CyTable> res = new HashSet<CyTable>();
            for (Long key : this.tables.keySet()) {
                if (!includePrivate && !this.tables.get(key).isPublic()) continue;
                res.add(this.tables.get(key));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyTable getTable(long suid) {
        Object object = this.lock;
        synchronized (object) {
            return this.tables.get(suid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTableInternal(long suid, boolean force) {
        CyTable table;
        Object object = this.lock;
        synchronized (object) {
            table = this.tables.get(suid);
            if (table == null) {
                return;
            }
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new TableAboutToBeDeletedEvent((CyTableManager)this, table));
        Object object2 = this.lock;
        synchronized (object2) {
            table = this.tables.get(suid);
            if (table == null) {
                return;
            }
            if (!force && table.getMutability() != CyTable.Mutability.MUTABLE) {
                throw new IllegalArgumentException("can't delete an immutable table.");
            }
            if (table instanceof CyTableImpl) {
                ((CyTableImpl)table).removeAllVirtColumns();
            }
            this.tables.remove(suid);
        }
        eventHelper.fireEvent((CyEvent)new TableDeletedEvent((CyTableManager)this));
        logger.debug("CyTable removed: table ID = " + table.getSUID());
        table = null;
    }

    public void deleteTable(long suid) {
        this.deleteTableInternal(suid, false);
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent e) {
        CyNetwork network = e.getNetwork();
        for (Class<? extends CyIdentifiable> type : COMPATIBLE_TYPES) {
            for (CyTable table : this.networkTableManager.getTables(network, type).values()) {
                this.deleteTableInternal(table.getSUID(), true);
            }
        }
    }

    public void handleEvent(EquationFunctionAddedEvent e) {
        this.refreshTableEquations();
    }

    public Set<CyTable> getGlobalTables() {
        HashSet nonGlobalTables = new HashSet();
        HashSet<CyTable> globalTables = new HashSet<CyTable>();
        Set networks = this.networkTableManager.getNetworkSet();
        for (CyNetwork network : networks) {
            for (Class<? extends CyIdentifiable> type : COMPATIBLE_TYPES) {
                Map objTables = this.networkTableManager.getTables(network, type);
                nonGlobalTables.addAll(objTables.values());
            }
        }
        for (CyTable table : this.tables.values()) {
            if (nonGlobalTables.contains(table)) continue;
            globalTables.add(table);
        }
        return globalTables;
    }

    public Set<CyTable> getLocalTables(Class<? extends CyIdentifiable> type) {
        HashSet<CyTable> localTables = new HashSet<CyTable>();
        Set networks = this.networkManager.getNetworkSet();
        for (CyNetwork network : networks) {
            Map objTables = this.networkTableManager.getTables(network, type);
            if (network instanceof CySubNetwork) {
                CyTable shared = this.networkTableManager.getTable((CyNetwork)((CySubNetwork)network).getRootNetwork(), type, "SHARED_ATTRS");
                localTables.add(shared);
            }
            localTables.addAll(objTables.values());
        }
        return localTables;
    }

    private void refreshTableEquations() {
        EquationCompiler compiler = (EquationCompiler)this.serviceRegistrar.getService(EquationCompiler.class);
        Set<CyTable> tables = this.getAllTables(true);
        for (CyTable table : tables) {
            EquationUtil.refreshEquations((CyTable)table, (EquationCompiler)compiler);
        }
    }
}

