/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.SUIDFactory;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.internal.CyEdgeImpl;
import org.cytoscape.model.internal.CyNodeImpl;
import org.cytoscape.model.internal.CySubNetworkImpl;
import org.cytoscape.model.internal.CyTableManagerImpl;
import org.cytoscape.model.internal.DefaultTablesNetwork;
import org.cytoscape.model.internal.InteractionSetListener;
import org.cytoscape.model.internal.NameSetListener;
import org.cytoscape.model.internal.NetworkNameSetListener;
import org.cytoscape.model.internal.RemovedAttributesCache;
import org.cytoscape.model.internal.SharedTableFacade;
import org.cytoscape.model.internal.VirtualColumnAdder;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedListener;

public final class CyRootNetworkImpl
extends DefaultTablesNetwork
implements CyRootNetwork,
NetworkAddedListener {
    private final long suid;
    private SavePolicy savePolicy;
    private final List<CySubNetwork> subNetworks;
    private CySubNetwork base;
    private final CyTableManagerImpl tableMgr;
    private final CyNetworkTableManager networkTableMgr;
    private final CyTableFactory tableFactory;
    private final boolean publicTables;
    private final VirtualColumnAdder columnAdder;
    private final NameSetListener nameSetListener;
    private final InteractionSetListener interactionSetListener;
    private final NetworkAddedListenerDelegator networkAddedListenerDelegator;
    private final NetworkNameSetListener networkNameSetListener;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();
    private int nextNodeIndex;
    private int nextEdgeIndex;
    private final RemovedAttributesCache removedAttributesCache;

    public CyRootNetworkImpl(CyEventHelper eh, CyTableManagerImpl tableMgr, CyNetworkTableManager networkTableMgr, CyTableFactory tableFactory, CyServiceRegistrar serviceRegistrar, boolean publicTables, SavePolicy savePolicy) {
        super(SUIDFactory.getNextSUID(), networkTableMgr, tableFactory, publicTables, 0, eh);
        assert (savePolicy != null);
        this.tableMgr = tableMgr;
        this.networkTableMgr = networkTableMgr;
        this.tableFactory = tableFactory;
        this.serviceRegistrar = serviceRegistrar;
        this.publicTables = publicTables;
        this.savePolicy = savePolicy;
        this.suid = super.getSUID();
        this.subNetworks = new ArrayList<CySubNetwork>();
        this.nextNodeIndex = 0;
        this.nextEdgeIndex = 0;
        this.createRootNetworkTables();
        this.initTables((CyNetwork)this, (SharedTableFacade)networkTableMgr.getTable((CyNetwork)this, CyNetwork.class, "SHARED_DEFAULT_ATTRS"), (SharedTableFacade)networkTableMgr.getTable((CyNetwork)this, CyNode.class, "SHARED_DEFAULT_ATTRS"), (SharedTableFacade)networkTableMgr.getTable((CyNetwork)this, CyEdge.class, "SHARED_DEFAULT_ATTRS"));
        this.setRootNetworkTablePrivacy();
        this.getRow((CyIdentifiable)this).set("name", (Object)"");
        this.removedAttributesCache = new RemovedAttributesCache((CyNetwork)this);
        this.columnAdder = new VirtualColumnAdder();
        serviceRegistrar.registerService((Object)this.columnAdder, ColumnCreatedListener.class, new Properties());
        this.nameSetListener = new NameSetListener();
        serviceRegistrar.registerService((Object)this.nameSetListener, RowsSetListener.class, new Properties());
        this.interactionSetListener = new InteractionSetListener();
        serviceRegistrar.registerService((Object)this.interactionSetListener, RowsSetListener.class, new Properties());
        this.networkAddedListenerDelegator = new NetworkAddedListenerDelegator();
        this.networkAddedListenerDelegator.addListener(this);
        serviceRegistrar.registerService((Object)this.networkAddedListenerDelegator, NetworkAddedListener.class, new Properties());
        this.networkNameSetListener = new NetworkNameSetListener(this);
        serviceRegistrar.registerService((Object)this.networkNameSetListener, RowsSetListener.class, new Properties());
        serviceRegistrar.registerService((Object)this.networkNameSetListener, NetworkAddedListener.class, new Properties());
        this.base = this.addSubNetwork();
    }

    public void dispose() {
        this.serviceRegistrar.unregisterAllServices((Object)this.columnAdder);
        this.serviceRegistrar.unregisterAllServices((Object)this.nameSetListener);
        this.serviceRegistrar.unregisterAllServices((Object)this.interactionSetListener);
        this.serviceRegistrar.unregisterAllServices((Object)this.networkAddedListenerDelegator);
        this.serviceRegistrar.unregisterAllServices((Object)this.networkNameSetListener);
        this.serviceRegistrar.unregisterService((Object)this, SessionLoadedListener.class);
        for (CySubNetwork network : this.subNetworks) {
            network.dispose();
        }
        Map tableMap = this.networkTableMgr.getTables((CyNetwork)this, CyNetwork.class);
        for (CyTable table : tableMap.values()) {
            this.tableMgr.deleteTableInternal(table.getSUID(), true);
        }
        tableMap = this.networkTableMgr.getTables((CyNetwork)this, CyNode.class);
        for (CyTable table : tableMap.values()) {
            this.tableMgr.deleteTableInternal(table.getSUID(), true);
        }
        tableMap = this.networkTableMgr.getTables((CyNetwork)this, CyEdge.class);
        for (CyTable table : tableMap.values()) {
            this.tableMgr.deleteTableInternal(table.getSUID(), true);
        }
        this.networkTableMgr.removeAllTables((CyNetwork)this);
        this.removedAttributesCache.dispose();
    }

    private void registerAllTables(Collection<CyTable> tables) {
        for (CyTable table : tables) {
            this.tableMgr.addTable(table);
        }
    }

    private void setRootNetworkTablePrivacy() {
        this.getDefaultEdgeTable().setPublic(false);
        this.getDefaultNetworkTable().setPublic(false);
        this.getDefaultNodeTable().setPublic(false);
    }

    private void createRootNetworkTables() {
        CyTable rawEdgeSharedTable = this.tableFactory.createTable(this.suid + " shared edge", "SUID", Long.class, false, false, CyRootNetworkImpl.getInitialTableSize(this.subNetworks.size()));
        SharedTableFacade edgeSharedTable = new SharedTableFacade(rawEdgeSharedTable, this, CyEdge.class, this.networkTableMgr, this.eventHelper);
        edgeSharedTable.setPublic(false);
        this.networkTableMgr.setTable((CyNetwork)this, CyEdge.class, "SHARED_ATTRS", rawEdgeSharedTable);
        this.networkTableMgr.setTable((CyNetwork)this, CyEdge.class, "SHARED_DEFAULT_ATTRS", (CyTable)edgeSharedTable);
        edgeSharedTable.createColumn("shared name", String.class, true);
        edgeSharedTable.createColumn("shared interaction", String.class, true);
        CyTable rawNetworkSharedTable = this.tableFactory.createTable(this.suid + " shared network", "SUID", Long.class, false, false, CyTableFactory.InitialTableSize.SMALL);
        SharedTableFacade networkSharedTable = new SharedTableFacade(rawNetworkSharedTable, this, CyNetwork.class, this.networkTableMgr, this.eventHelper);
        networkSharedTable.setPublic(false);
        this.networkTableMgr.setTable((CyNetwork)this, CyNetwork.class, "SHARED_ATTRS", rawNetworkSharedTable);
        this.networkTableMgr.setTable((CyNetwork)this, CyNetwork.class, "SHARED_DEFAULT_ATTRS", (CyTable)networkSharedTable);
        networkSharedTable.createColumn("shared name", String.class, true);
        CyTable rawNodeSharedTable = this.tableFactory.createTable(this.suid + " shared node", "SUID", Long.class, false, false, CyRootNetworkImpl.getInitialTableSize(this.subNetworks.size()));
        SharedTableFacade nodeSharedTable = new SharedTableFacade(rawNodeSharedTable, this, CyNode.class, this.networkTableMgr, this.eventHelper);
        nodeSharedTable.setPublic(false);
        this.networkTableMgr.setTable((CyNetwork)this, CyNode.class, "SHARED_ATTRS", rawNodeSharedTable);
        this.networkTableMgr.setTable((CyNetwork)this, CyNode.class, "SHARED_DEFAULT_ATTRS", (CyTable)nodeSharedTable);
        nodeSharedTable.createColumn("shared name", String.class, true);
    }

    private void linkDefaultTables(CyTable sharedTable, CyTable localTable) {
        this.nameSetListener.addInterestedTables(localTable, sharedTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNode addNode() {
        CyNodeImpl node;
        Object object = this.lock;
        synchronized (object) {
            node = new CyNodeImpl(SUIDFactory.getNextSUID(), this.getNextNodeIndex(), this.eventHelper);
            this.addNodeInternal(node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNodes(Collection<CyNode> nodes) {
        Object object = this.lock;
        synchronized (object) {
            boolean removed = false;
            for (CySubNetwork sub : this.subNetworks) {
                removed |= sub.removeNodes(nodes);
                if (nodes == null || !(sub instanceof CySubNetworkImpl)) continue;
                ((CySubNetworkImpl)sub).removeRows(nodes, CyNode.class);
            }
            if (nodes != null) {
                for (CyNode node : nodes) {
                    this.removedAttributesCache.evict((CyIdentifiable)node);
                }
            }
            this.removeRows(nodes, CyNode.class);
            return removed |= this.removeNodesInternal(nodes);
        }
    }

    void subnetworkNodesRemoved(Collection<CyNode> nodes) {
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        for (CyNode node : nodes) {
            for (CyEdge edge : this.getAdjacentEdgeIterable(node, CyEdge.Type.ANY)) {
                edges.add(edge);
            }
        }
        this.subnetworkEdgesRemoved(edges);
        List<CyNode> nodesToCache = nodes.stream().filter(n -> this.containsNode((CyNode)n)).filter(n -> !this.anySubnetworkContains((CyNode)n)).collect(Collectors.toList());
        this.removedAttributesCache.cache(nodesToCache);
        this.removeRows(nodesToCache, CyNode.class);
        this.removeNodesInternal(nodesToCache);
    }

    void subnetworkEdgesRemoved(Collection<CyEdge> edges) {
        List<CyEdge> edgesToCache = edges.stream().filter(e -> this.containsEdge((CyEdge)e)).filter(e -> !this.anySubnetworkContains((CyEdge)e)).collect(Collectors.toList());
        this.removedAttributesCache.cache(edgesToCache);
        this.removeRows(edgesToCache, CyEdge.class);
        this.removeEdgesInternal(edgesToCache);
    }

    void garbageCollect() {
        List<CyNode> garbageNodes = this.getNodeList().stream().filter(n -> !this.anySubnetworkContains((CyNode)n)).collect(Collectors.toList());
        List<CyEdge> garbageEdges = this.getEdgeList().stream().filter(e -> !this.anySubnetworkContains((CyEdge)e)).collect(Collectors.toList());
        this.removedAttributesCache.cache(garbageNodes);
        this.removedAttributesCache.cache(garbageEdges);
        this.removeRows(garbageNodes, CyNode.class);
        this.removeRows(garbageEdges, CyEdge.class);
        this.removeNodesInternal(garbageNodes);
        this.removeEdgesInternal(garbageEdges);
    }

    CyRow getCachedAttributes(CyIdentifiable element) {
        return this.getCachedAttributes(element, "USER");
    }

    CyRow getCachedAttributes(CyIdentifiable element, String namespace) {
        if (element instanceof CyNode && super.containsNode((CyNode)element)) {
            return this.getRow(element, namespace);
        }
        if (element instanceof CyEdge && super.containsEdge((CyEdge)element)) {
            return this.getRow(element, namespace);
        }
        if (this.removedAttributesCache.contains(element)) {
            return this.removedAttributesCache.getAttributes(element, namespace);
        }
        return null;
    }

    boolean cachedEdge(CyEdge edge) {
        return this.removedAttributesCache.contains((CyIdentifiable)edge);
    }

    boolean cachedNode(CyNode node) {
        return this.removedAttributesCache.contains((CyIdentifiable)node);
    }

    private boolean anySubnetworkContains(CyNode node) {
        return this.subNetworks.stream().anyMatch(sub -> sub.containsNode(node));
    }

    private boolean anySubnetworkContains(CyEdge edge) {
        return this.subNetworks.stream().anyMatch(sub -> sub.containsEdge(edge));
    }

    public void restoreNode(CyNode node) {
        if (this.containsNode(node)) {
            return;
        }
        if (this.removedAttributesCache.contains((CyIdentifiable)node)) {
            this.removedAttributesCache.restore((CyIdentifiable)node);
            this.addNodeInternal(node);
        }
    }

    public void restoreEdge(CyEdge edge) {
        if (this.containsEdge(edge)) {
            return;
        }
        if (this.removedAttributesCache.contains((CyIdentifiable)edge)) {
            this.restoreNode(edge.getSource());
            this.restoreNode(edge.getTarget());
            this.removedAttributesCache.restore((CyIdentifiable)edge);
            this.addEdgeInternal(edge.getSource(), edge.getTarget(), edge.isDirected(), edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyEdge addEdge(CyNode s, CyNode t, boolean directed) {
        CyEdgeImpl edge;
        Object object = this.lock;
        synchronized (object) {
            edge = new CyEdgeImpl(SUIDFactory.getNextSUID(), s, t, directed, this.getNextEdgeIndex());
            this.addEdgeInternal(s, t, directed, edge);
        }
        return edge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEdges(Collection<CyEdge> edges) {
        Object object = this.lock;
        synchronized (object) {
            for (CySubNetwork sub : this.subNetworks) {
                sub.removeEdges(edges);
                if (edges == null || !(sub instanceof CySubNetworkImpl)) continue;
                ((CySubNetworkImpl)sub).removeRows(edges, CyEdge.class);
            }
            if (edges != null) {
                for (CyEdge edge : edges) {
                    this.removedAttributesCache.evict((CyIdentifiable)edge);
                }
            }
            return this.removeEdgesInternal(edges);
        }
    }

    public CySubNetwork addSubNetwork(Iterable<CyNode> nodes, Iterable<CyEdge> edges) {
        return this.addSubNetwork(nodes, edges, this.savePolicy);
    }

    public CySubNetwork addSubNetwork(Iterable<CyNode> nodes, Iterable<CyEdge> edges, SavePolicy policy) {
        CySubNetwork sub = this.addSubNetwork(policy);
        if (nodes != null) {
            for (CyNode n : nodes) {
                sub.addNode(n);
            }
        }
        if (edges != null) {
            for (CyEdge e : edges) {
                sub.addEdge(e);
            }
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CySubNetwork addSubNetwork() {
        Object object = this.lock;
        synchronized (object) {
            return this.addSubNetwork(this.savePolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CySubNetwork addSubNetwork(SavePolicy policy) {
        Object object = this.lock;
        synchronized (object) {
            if (policy == null) {
                policy = this.savePolicy;
            }
            if (this.savePolicy == SavePolicy.DO_NOT_SAVE && policy != this.savePolicy) {
                throw new IllegalArgumentException("Cannot create subnetwork with \"" + policy + "\" save policy, because this root network's policy is \"DO_NOT_SAVE\".");
            }
            long newSUID = SUIDFactory.getNextSUID();
            CySubNetworkImpl sub = new CySubNetworkImpl(this, newSUID, this.eventHelper, this.tableMgr, this.networkTableMgr, this.tableFactory, this.publicTables, this.subNetworks.size(), policy);
            this.networkAddedListenerDelegator.addListener(sub);
            this.subNetworks.add(sub);
            this.nameSetListener.addInterestedTables(sub.getDefaultNetworkTable(), this.networkTableMgr.getTable((CyNetwork)this, CyNetwork.class, "SHARED_DEFAULT_ATTRS"));
            this.nameSetListener.addInterestedTables(sub.getDefaultNodeTable(), this.networkTableMgr.getTable((CyNetwork)this, CyNode.class, "SHARED_DEFAULT_ATTRS"));
            this.nameSetListener.addInterestedTables(sub.getDefaultEdgeTable(), this.networkTableMgr.getTable((CyNetwork)this, CyEdge.class, "SHARED_DEFAULT_ATTRS"));
            this.interactionSetListener.addInterestedTables(sub.getDefaultEdgeTable(), this.networkTableMgr.getTable((CyNetwork)this, CyEdge.class, "SHARED_DEFAULT_ATTRS"));
            return sub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubNetwork(CySubNetwork sub) {
        Object object = this.lock;
        synchronized (object) {
            if (sub == null) {
                return;
            }
            if (!this.subNetworks.contains(sub)) {
                throw new IllegalArgumentException("Subnetwork not a member of this RootNetwork " + sub);
            }
            if (sub.equals(this.base)) {
                if (this.subNetworks.size() == 1) {
                    throw new IllegalArgumentException("Can't remove base network from RootNetwork because it's the only subnetwork");
                }
                CySubNetwork oldBase = this.base;
                for (CySubNetwork n : this.subNetworks) {
                    if (n.equals(oldBase)) continue;
                    this.base = n;
                    if (n.getSavePolicy() != SavePolicy.SESSION_FILE) continue;
                    break;
                }
            }
            sub.removeNodes((Collection)sub.getNodeList());
            Map tableMap = this.networkTableMgr.getTables((CyNetwork)sub, CyNetwork.class);
            for (CyTable table : tableMap.values()) {
                this.tableMgr.deleteTableInternal(table.getSUID(), true);
            }
            tableMap = this.networkTableMgr.getTables((CyNetwork)sub, CyNode.class);
            for (CyTable table : tableMap.values()) {
                this.tableMgr.deleteTableInternal(table.getSUID(), true);
            }
            tableMap = this.networkTableMgr.getTables((CyNetwork)sub, CyEdge.class);
            for (CyTable table : tableMap.values()) {
                this.tableMgr.deleteTableInternal(table.getSUID(), true);
            }
            this.subNetworks.remove(sub);
            sub.dispose();
            this.garbageCollect();
        }
    }

    public List<CySubNetwork> getSubNetworkList() {
        return new ArrayList<CySubNetwork>(this.subNetworks);
    }

    public CySubNetwork getBaseNetwork() {
        return this.base;
    }

    public CyTable getSharedNetworkTable() {
        return this.networkTableMgr.getTable((CyNetwork)this, CyNetwork.class, "SHARED_DEFAULT_ATTRS");
    }

    public CyTable getSharedNodeTable() {
        return this.networkTableMgr.getTable((CyNetwork)this, CyNode.class, "SHARED_DEFAULT_ATTRS");
    }

    public CyTable getSharedEdgeTable() {
        return this.networkTableMgr.getTable((CyNetwork)this, CyEdge.class, "SHARED_DEFAULT_ATTRS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNetwork(CyNetwork net) {
        Object object = this.lock;
        synchronized (object) {
            return this.subNetworks.contains(net);
        }
    }

    public SavePolicy getSavePolicy() {
        return this.savePolicy;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CyRootNetworkImpl)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        String name = null;
        try {
            name = (String)this.getRow((CyIdentifiable)this).get("name", String.class);
        }
        catch (NullPointerException e) {
            name = "(unavailable)";
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextNodeIndex() {
        Object object = this.lock;
        synchronized (object) {
            return this.nextNodeIndex++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextEdgeIndex() {
        Object object = this.lock;
        synchronized (object) {
            return this.nextEdgeIndex++;
        }
    }

    public void handleEvent(NetworkAddedEvent e) {
        if (e.getNetwork() == this || this.subNetworks.contains(e.getNetwork())) {
            CyNetworkManager netManager = (CyNetworkManager)e.getSource();
            ArrayList<CyRootNetworkImpl> networks = new ArrayList<CyRootNetworkImpl>();
            networks.add(this);
            networks.addAll(this.subNetworks);
            networks.remove(e.getNetwork());
            for (CyNetwork cyNetwork : networks) {
                if (!netManager.networkExists(cyNetwork.getSUID().longValue())) continue;
                return;
            }
            this.registerAllTables(this.networkTableMgr.getTables((CyNetwork)this, CyNetwork.class).values());
            this.registerAllTables(this.networkTableMgr.getTables((CyNetwork)this, CyNode.class).values());
            this.registerAllTables(this.networkTableMgr.getTables((CyNetwork)this, CyEdge.class).values());
        }
    }

    private class NetworkAddedListenerDelegator
    implements NetworkAddedListener {
        List<WeakReference<NetworkAddedListener>> listeners = new ArrayList<WeakReference<NetworkAddedListener>>();

        private NetworkAddedListenerDelegator() {
        }

        public void addListener(NetworkAddedListener l) {
            this.listeners.add(new WeakReference<NetworkAddedListener>(l));
        }

        public void handleEvent(NetworkAddedEvent e) {
            for (WeakReference<NetworkAddedListener> ref : this.listeners) {
                NetworkAddedListener l = (NetworkAddedListener)ref.get();
                if (l == null) continue;
                l.handleEvent(e);
            }
        }
    }
}

