/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.List;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.internal.WeakMapList;

public class ColumnSetListener
implements RowsSetListener {
    private final WeakMapList<CyTable, CyTable> tables;
    private final String columnName;
    private final String sharedColumnName;
    private final Object lock = new Object();

    ColumnSetListener(String columnName, String sharedColumnName) {
        this.tables = new WeakMapList();
        this.columnName = columnName;
        this.sharedColumnName = sharedColumnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(RowsSetEvent e) {
        CyTable local = (CyTable)e.getSource();
        Object object = this.lock;
        synchronized (object) {
            List<CyTable> sharedList = this.tables.get(local);
            for (CyTable shared : sharedList) {
                for (RowSetRecord record : e.getColumnRecords(this.columnName)) {
                    CyRow r = shared.getRow(record.getRow().get("SUID", Long.class));
                    if (r == null) continue;
                    Object name = record.getValue();
                    String sharedName = (String)r.get(this.sharedColumnName, String.class);
                    if (sharedName != null) continue;
                    r.set(this.sharedColumnName, name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestedTables(CyTable local, CyTable shared) {
        if (shared == null) {
            throw new NullPointerException("source table is null");
        }
        if (local == null) {
            throw new NullPointerException("target table is null");
        }
        if (shared == local) {
            throw new IllegalArgumentException("source and target tables cannot be the same.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.tables.put(local, shared);
        }
    }
}

