/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.vizmap;

import java.io.File;
import java.io.OutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.io.write.VizmapWriterManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.TunableAbstractCyWriter;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListMultipleSelection;

public class VizmapWriter
extends TunableAbstractCyWriter<VizmapWriterFactory, VizmapWriterManager> {
    @Tunable(description="Styles:", longDescription="The styles to be exported. If no styles are specified, only the current one is exported.", exampleStringValue="Minimal,default,Directed")
    public ListMultipleSelection<VisualStyle> styles;

    @ProvidesTitle
    public String getTitle() {
        return "Export Styles";
    }

    @Override
    @Tunable(description="Save Styles as:", longDescription="The path name of the file where the styles must be saved to.", exampleStringValue="/Users/johndoe/Downloads/MyStyles.xml", params="fileCategory=vizmap;input=false", required=true, gravity=1.1)
    public File getOutputFile() {
        return this.outputFile;
    }

    public VizmapWriter(VizmapWriterManager writerManager, CyApplicationManager cyApplicationManager, CyServiceRegistrar serviceRegistrar) {
        super(writerManager, cyApplicationManager);
        VisualMappingManager vmMgr = (VisualMappingManager)serviceRegistrar.getService(VisualMappingManager.class);
        ArrayList allStyles = new ArrayList(vmMgr.getAllVisualStyles());
        final Collator collator = Collator.getInstance(Locale.getDefault());
        Collections.sort(allStyles, new Comparator<VisualStyle>(){

            @Override
            public int compare(VisualStyle vs1, VisualStyle vs2) {
                return collator.compare(vs1.getTitle(), vs2.getTitle());
            }
        });
        this.styles = new ListMultipleSelection(allStyles);
        this.styles.setSelectedValues(Collections.singletonList(vmMgr.getCurrentVisualStyle()));
        this.outputFile = this.getSuggestedFile();
    }

    void setDefaultFileFormatUsingFileExt(File file) {
        String ext = FilenameUtils.getExtension((String)file.getName());
        ext = ext.toLowerCase().trim();
        String searchDesc = "*." + ext;
        for (String fileTypeDesc : this.getFileFilterDescriptions()) {
            if (!fileTypeDesc.contains(searchDesc)) continue;
            this.options.setSelectedValue((Object)fileTypeDesc);
            break;
        }
    }

    @Override
    protected CyWriter getWriter(CyFileFilter filter) throws Exception {
        LinkedHashSet selectedStyles = new LinkedHashSet(this.styles.getSelectedValues());
        return ((VizmapWriterManager)this.writerManager).getWriter(selectedStyles, filter, (OutputStream)this.outputStream);
    }

    @Override
    public TunableValidator.ValidationState getValidationState(Appendable msg) {
        if (this.styles.getSelectedValues().isEmpty()) {
            try {
                msg.append("Select at least one Style.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return super.getValidationState(msg);
    }

    @Override
    protected String getExportName() {
        return "styles";
    }
}

