/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.vizmap;

import java.util.Collection;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewCollectionTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.TaskMonitor;

public class ClearAllEdgeBendsTask
extends AbstractNetworkViewCollectionTask {
    private final CyServiceRegistrar serviceRegistrar;

    public ClearAllEdgeBendsTask(Collection<CyNetworkView> networkViews, CyServiceRegistrar serviceRegistrar) {
        super(networkViews);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Clear All Edge Bends");
        tm.setProgress(0.0);
        VisualMappingManager vmManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        int count = 1;
        int total = this.networkViews.size();
        for (CyNetworkView nv : this.networkViews) {
            if (this.cancelled) {
                return;
            }
            tm.setStatusMessage(count + " of " + total + ": " + DataUtils.getViewTitle(nv) + "...");
            tm.setProgress((double)((float)count / (float)total));
            nv.setViewDefault((VisualProperty)BasicVisualLexicon.EDGE_BEND, null);
            VisualStyle vs = vmManager.getVisualStyle(nv);
            vs.setDefaultValue((VisualProperty)BasicVisualLexicon.EDGE_BEND, null);
            vs.removeVisualMappingFunction((VisualProperty)BasicVisualLexicon.EDGE_BEND);
            Collection edgeViews = nv.getEdgeViews();
            for (View ev : edgeViews) {
                ev.setVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND, null);
                ev.clearValueLock((VisualProperty)BasicVisualLexicon.EDGE_BEND);
            }
            nv.updateView();
            ++count;
        }
        tm.setProgress(1.0);
    }
}

