/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class GetCurrentNetworkViewTask
extends AbstractTask
implements ObservableTask {
    private CyNetworkView view;
    private final CyServiceRegistrar serviceRegistrar;

    public GetCurrentNetworkViewTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Get Current Network View");
        this.view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        tm.showMessage(TaskMonitor.Level.INFO, "Current network view is " + this.view);
    }

    public Object getResults(Class type) {
        if (type == String.class) {
            return this.view != null ? this.view.toString() : null;
        }
        if (type == JSONResult.class) {
            String json = this.view != null ? ((CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class)).toJson((CyIdentifiable)this.view) : null;
            JSONResult res = () -> "{ \"view\":" + json + "}";
            return res;
        }
        return this.view;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyNetworkView.class, String.class, JSONResult.class);
    }
}

