/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkCollectionTaskFactory;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.task.internal.view.CreateNetworkViewTask;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class CreateNetworkViewTaskFactoryImpl
extends AbstractNetworkCollectionTaskFactory
implements CreateNetworkViewTaskFactory,
TaskFactory {
    private final CyNetworkManager netMgr;
    private final CyLayoutAlgorithmManager layoutMgr;
    private final CyApplicationManager appMgr;
    private final CyServiceRegistrar serviceRegistrar;
    private final Set<NetworkViewRenderer> viewRenderers;

    public CreateNetworkViewTaskFactoryImpl(CyNetworkManager netMgr, CyLayoutAlgorithmManager layoutMgr, CyApplicationManager appMgr, CyServiceRegistrar serviceRegistrar) {
        this.netMgr = netMgr;
        this.layoutMgr = layoutMgr;
        this.appMgr = appMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.viewRenderers = new HashSet<NetworkViewRenderer>();
    }

    public TaskIterator createTaskIterator(Collection<CyNetwork> networks, CyNetworkViewFactory factory) {
        int expectedNumTasks = this.layoutMgr == null ? 1 : 2;
        return new TaskIterator(expectedNumTasks, new Task[]{new CreateNetworkViewTask(networks, factory, this.netMgr, this.layoutMgr, this.appMgr, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(Collection<CyNetwork> networks) {
        if (this.viewRenderers.isEmpty()) {
            throw new RuntimeException("Unnable to create Network View: There is no NetworkViewRenderer.");
        }
        int expectedNumTasks = this.layoutMgr == null ? 1 : 2;
        return new TaskIterator(expectedNumTasks, new Task[]{new CreateNetworkViewTask(networks, this.netMgr, this.layoutMgr, this.appMgr, this.viewRenderers, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator() {
        return this.createTaskIterator(Collections.singletonList(this.appMgr.getCurrentNetwork()));
    }

    public boolean isReady() {
        return this.appMgr.getCurrentNetwork() != null;
    }

    public boolean isReady(Collection<CyNetwork> networks) {
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        for (CyNetwork n : networks) {
            if (!netViewMgr.getNetworkViews(n).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addNetworkViewRenderer(NetworkViewRenderer renderer, Map<?, ?> props) {
        this.viewRenderers.add(renderer);
    }

    public void removeNetworkViewRenderer(NetworkViewRenderer renderer, Map<?, ?> props) {
        this.viewRenderers.remove(renderer);
    }
}

