/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkCollectionTask;
import org.cytoscape.task.internal.layout.ApplyPreferredLayoutTask;
import org.cytoscape.task.internal.network.RegisterNetworkTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.view.CopyExistingViewTask;
import org.cytoscape.task.internal.view.CreateNetworkViewEdit;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNetworkViewTask
extends AbstractNetworkCollectionTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyNetworkManager netMgr;
    private CyNetworkViewFactory viewFactory;
    private final Set<NetworkViewRenderer> viewRenderers;
    private final CyLayoutAlgorithmManager layoutMgr;
    private final CyApplicationManager appMgr;
    private final CyServiceRegistrar serviceRegistrar;
    private final CyNetworkView sourceView;
    private List<CyNetworkView> networkViews;
    @Tunable(description="Network", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;
    @Tunable(description="Layout the resulting view?", longDescription="If true (default), the preferred layout will be applied to the new view. If false, no layout will be applied.", exampleStringValue="false", context="nogui")
    public boolean layout = true;

    public CreateNetworkViewTask(Collection<CyNetwork> networks, CyNetworkManager netMgr, CyLayoutAlgorithmManager layoutMgr, CyApplicationManager appMgr, Set<NetworkViewRenderer> viewRenderers, CyServiceRegistrar serviceRegistrar) {
        this(networks, null, netMgr, layoutMgr, appMgr, serviceRegistrar);
        if (viewRenderers != null) {
            this.viewRenderers.addAll(viewRenderers);
            if (viewRenderers.size() == 1) {
                this.viewFactory = viewRenderers.iterator().next().getNetworkViewFactory();
            }
        }
    }

    public CreateNetworkViewTask(Collection<CyNetwork> networks, CyNetworkViewFactory viewFactory, CyNetworkManager netMgr, CyLayoutAlgorithmManager layoutMgr, CyApplicationManager appMgr, CyNetworkView sourceView, CyServiceRegistrar serviceRegistrar) {
        super(networks);
        this.viewFactory = viewFactory;
        this.netMgr = netMgr;
        this.layoutMgr = layoutMgr;
        this.appMgr = appMgr;
        this.sourceView = sourceView;
        this.serviceRegistrar = serviceRegistrar;
        this.networkViews = new ArrayList<CyNetworkView>();
        this.viewRenderers = new TreeSet<NetworkViewRenderer>(new Comparator<NetworkViewRenderer>(){

            @Override
            public int compare(NetworkViewRenderer r1, NetworkViewRenderer r2) {
                return r1.toString().compareToIgnoreCase(r2.toString());
            }
        });
    }

    public CreateNetworkViewTask(Collection<CyNetwork> networks, CyNetworkViewFactory viewFactory, CyNetworkManager netMgr, CyLayoutAlgorithmManager layoutMgr, CyApplicationManager appMgr, CyServiceRegistrar serviceRegistrar) {
        this(networks, viewFactory, netMgr, layoutMgr, appMgr, null, serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Create Network View(s)");
        tm.setProgress(0.0);
        List<CyNetwork> netList = this.network != null ? Collections.singletonList(this.network) : this.networks;
        int total = netList.size();
        tm.setStatusMessage("Creating " + total + " view" + (total == 1 ? "" : "s") + "...");
        if (this.viewFactory == null && this.viewRenderers.size() > 1) {
            ChooseViewRendererTask chooseRendererTask = new ChooseViewRendererTask(netList);
            this.insertTasksAfterCurrentTask(new Task[]{chooseRendererTask});
        } else {
            CyNetwork curNet = this.appMgr.getCurrentNetwork();
            CyNetworkView curView = this.appMgr.getCurrentNetworkView();
            CyRootNetworkManager rootNetMgr = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
            CyNetworkViewManager viewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            VisualMappingManager visMapMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
            VisualStyle style = null;
            int i = 0;
            int viewCount = netList.size();
            for (CyNetwork n : netList) {
                style = visMapMgr.getDefaultVisualStyle();
                if (this.cancelled) break;
                if (viewMgr.viewExists(n)) continue;
                CyRootNetwork rootNet = rootNetMgr.getRootNetwork(n);
                Collection baseViewSet = viewMgr.getNetworkViews((CyNetwork)rootNet.getBaseNetwork());
                if (!baseViewSet.isEmpty()) {
                    style = visMapMgr.getVisualStyle((CyNetworkView)baseViewSet.iterator().next());
                }
                CyNetworkView view = this.createView(n, style, tm);
                this.networkViews.add(view);
                if (curView == null && n.equals(curNet)) {
                    curView = view;
                }
                tm.setStatusMessage("Network view successfully created for: " + DataUtils.getNetworkName(n));
                tm.setProgress((double)(++i) / (double)viewCount);
            }
            if (!this.cancelled) {
                if (this.layoutMgr == null) {
                    this.insertTasksAfterCurrentTask(new Task[]{new RegisterNetworkTask(this.networkViews.get(0), style, this.serviceRegistrar)});
                } else {
                    this.insertTasksAfterCurrentTask(new Task[]{new RegisterNetworkTask(this.networkViews, null, this.serviceRegistrar)});
                }
            }
        }
        if (this.cancelled) {
            this.disposeNewViews();
            return;
        }
        tm.setProgress(1.0);
    }

    private final CyNetworkView createView(CyNetwork network, VisualStyle style, TaskMonitor tm) throws Exception {
        long start = System.currentTimeMillis();
        try {
            CyNetworkView vmMgr;
            long startnv = System.currentTimeMillis();
            CyNetworkView view = this.viewFactory.createNetworkView(network);
            System.out.println("Network factory creation finished in " + (System.currentTimeMillis() - startnv) + " msec.");
            CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            Collection netViews = netViewMgr.getNetworkViews(network);
            Object title = (String)network.getDefaultNetworkTable().getRow((Object)network.getSUID()).get("name", String.class);
            title = (String)title + (String)(netViews.isEmpty() ? "" : " (" + (netViews.size() + 1) + ")");
            view.setVisualProperty(BasicVisualLexicon.NETWORK_TITLE, title);
            if (this.cancelled) {
                CyNetworkView cyNetworkView = view;
                return cyNetworkView;
            }
            netViewMgr.addNetworkView(view, false);
            if (style != null) {
                vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
                vmMgr.setVisualStyle(style, view);
                style.apply(view);
            }
            if (this.cancelled) {
                vmMgr = view;
                return vmMgr;
            }
            if (this.sourceView != null) {
                this.insertTasksAfterCurrentTask(new Task[]{new CopyExistingViewTask(view, this.sourceView, style, null, null, true, this.serviceRegistrar)});
            } else if (this.layout) {
                HashSet<CyNetworkView> views = new HashSet<CyNetworkView>();
                views.add(view);
                this.insertTasksAfterCurrentTask(new Task[]{new ApplyPreferredLayoutTask(views, this.serviceRegistrar)});
            }
            CyNetworkView cyNetworkView = view;
            return cyNetworkView;
        }
        catch (Exception e) {
            throw new Exception("Could not create network view for network: " + DataUtils.getNetworkName(network), e);
        }
        finally {
            ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new CreateNetworkViewEdit(network, this.serviceRegistrar));
            logger.info("Network view creation finished in " + (System.currentTimeMillis() - start) + " msec.");
        }
    }

    private void disposeNewViews() {
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        Set viewSet = netViewMgr.getNetworkViewSet();
        Iterator<CyNetworkView> iter = this.networkViews.iterator();
        while (iter.hasNext()) {
            CyNetworkView view = iter.next();
            iter.remove();
            if (viewSet.contains(view)) {
                netViewMgr.destroyNetworkView(view);
                continue;
            }
            view.dispose();
        }
    }

    public Object getResults(Class type) {
        return new ArrayList<CyNetworkView>(this.networkViews);
    }

    public class ChooseViewRendererTask
    extends AbstractNetworkCollectionTask {
        @Tunable(description="Network View Renderer:")
        public ListSingleSelection<NetworkViewRenderer> renderers;

        public ChooseViewRendererTask(Collection<CyNetwork> networks) {
            super(networks);
            this.renderers = new ListSingleSelection(new ArrayList<NetworkViewRenderer>(CreateNetworkViewTask.this.viewRenderers));
            NetworkViewRenderer defViewRenderer = CreateNetworkViewTask.this.appMgr.getDefaultNetworkViewRenderer();
            if (defViewRenderer != null && CreateNetworkViewTask.this.viewRenderers.contains(defViewRenderer)) {
                this.renderers.setSelectedValue((Object)defViewRenderer);
            }
        }

        @ProvidesTitle
        public String getTitle() {
            return "Choose a Network View Renderer";
        }

        public void run(TaskMonitor tm) throws Exception {
            CyNetworkViewFactory viewFactory = ((NetworkViewRenderer)this.renderers.getSelectedValue()).getNetworkViewFactory();
            CreateNetworkViewTask createViewTask = new CreateNetworkViewTask((Collection<CyNetwork>)this.networks, viewFactory, CreateNetworkViewTask.this.netMgr, CreateNetworkViewTask.this.layoutMgr, CreateNetworkViewTask.this.appMgr, CreateNetworkViewTask.this.serviceRegistrar);
            if (!this.cancelled) {
                this.insertTasksAfterCurrentTask(new Task[]{createViewTask});
            }
        }
    }
}

