/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.utils;

import java.util.List;
import org.cytoscape.command.util.RowList;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;

public class RowTunable {
    @ContainsTunables
    public TableTunable tableTunable;
    public RowList rowList;

    @Tunable(description="List of rows", context="nogui", longDescription="Specifies a list of rows. The pattern ```COLUMN:VALUE``` sets this parameter to any rows that contain the specified column value; if the ```COLUMN``` prefix is not used, the NAME column is matched by default. A list of ```COLUMN:VALUE``` pairs of the format ```COLUMN1:VALUE1,COLUMN2:VALUE2,...``` can be used to match multiple values. This parameter can also be set to ```all``` to include all rows.", exampleStringValue="name:BRCA1,name:BRCA2,name:EGFR")
    public RowList getrowList() {
        this.rowList.setTable(this.tableTunable.getTable());
        return this.rowList;
    }

    public void setrowList(RowList setValue) {
    }

    public RowTunable(CyServiceRegistrar serviceRegistrar) {
        this.tableTunable = new TableTunable(serviceRegistrar);
        this.rowList = new RowList(null);
    }

    public CyTable getTable() {
        return this.tableTunable.getTable();
    }

    public String getTableString() {
        return this.tableTunable.getTableString();
    }

    public List<CyRow> getRowList() {
        if (this.rowList == null || this.rowList.getValue() == null) {
            return this.getTable().getAllRows();
        }
        return this.rowList.getValue();
    }
}

