/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.utils;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.Tunable;

public class ColumnListTunable {
    @Tunable(description="Namespace for table", context="nogui", longDescription="Node, Edge, and Network objects support the ```default```, ```local```, and ```hidden``` namespaces. Root networks also support the ```shared``` namespace. Custom namespaces may be specified by Apps.", exampleStringValue="default")
    public String namespace = "default";
    @Tunable(description="Column list", context="nogui", longDescription="A list of column names, separated by commas.", exampleStringValue="name,Column B")
    public String columnList = "all";

    public String getNamespace() {
        return this.namespace;
    }

    public List<CyColumn> getColumnList(CyTable table) {
        if (table == null) {
            return null;
        }
        if (this.columnList == null || this.columnList.equalsIgnoreCase("all")) {
            return new ArrayList<CyColumn>(table.getColumns());
        }
        String[] columns = this.columnList.split(",");
        ArrayList<CyColumn> returnValue = new ArrayList<CyColumn>();
        for (String column : columns) {
            CyColumn c = table.getColumn(column);
            if (c == null) continue;
            returnValue.add(c);
        }
        return returnValue;
    }

    public List<String> getColumnNames(CyTable table) {
        if (table == null) {
            return null;
        }
        ArrayList<String> resultString = new ArrayList<String>();
        for (CyColumn column : this.getColumnList(table)) {
            resultString.add(column.getName());
        }
        return resultString;
    }
}

