/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnValueTunable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.NodeTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;

public class SetNodeAttributeTask
extends AbstractTableDataTask {
    @ContainsTunables
    public NodeTunable nodeTunable;
    @ContainsTunables
    public ColumnValueTunable columnTunable;

    public SetNodeAttributeTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.nodeTunable = new NodeTunable(serviceRegistrar);
        this.columnTunable = new ColumnValueTunable();
    }

    public void run(TaskMonitor tm) {
        CyNetwork network = this.nodeTunable.getNetwork();
        CyTable nodeTable = this.getNetworkTable(network, CyNode.class, this.columnTunable.getNamespace());
        for (CyNode node : this.nodeTunable.getNodeList()) {
            int count = this.setCyIdentifierData(nodeTable, (CyIdentifiable)node, this.columnTunable.getValueMap(nodeTable));
            tm.showMessage(TaskMonitor.Level.INFO, "   Set " + count + " node table values for node " + DataUtils.getNodeName(nodeTable, node));
        }
    }
}

