/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTablesTask
extends AbstractTask
implements TunableValidator,
ObservableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String NO_NETWORKS = "No Networks Found";
    public static final String NO_TABLES = "No Tables Found";
    public static final String NETWORK_COLLECTION = "a network collection";
    public static final String NETWORK_SELECTION = "selected networks only";
    public static final String UNASSIGNED_TABLE = "an unassigned table";
    public static final String COPY_COLUMNS = "Copy Columns";
    public static final String LINK_COLUMNS = "Link To Columns";
    private Map<String, CyNetwork> name2NetworkMap;
    private Map<String, CyRootNetwork> name2RootMap;
    private Map<String, String> source2targetColumnMap;
    private List<Long> tableSUIDs;
    private final CyServiceRegistrar serviceRegistrar;
    public ListSingleSelection<CyTable> sourceTable;
    public ListMultipleSelection<String> sourceMergeColumns;
    public ListSingleSelection<String> sourceMergeKey;
    @Tunable(description="Type of merge", gravity=0.5, groups={"Source"}, listenForChange={"SourceTable"}, longDescription="A choice between ''Copy Columns'' and ''Link To Columns'' that determines if replicates are created", exampleStringValue="Copy Columns")
    public ListSingleSelection<String> mergeType;
    public ListSingleSelection<String> whereMergeTable;
    public ListSingleSelection<String> targetNetworkCollection;
    public ListSingleSelection<TableType> dataTypeTargetForNetworkCollection;
    public ListSingleSelection<String> targetKeyNetworkCollection;
    public ListMultipleSelection<String> targetNetworkList;
    @Tunable(description="Merge data in:", groups={"Target", "Select Networks"}, gravity=3.2, xorKey="selected networks only", longDescription="", exampleStringValue="")
    public ListSingleSelection<TableType> dataTypeTargetForNetworkList;
    public ListSingleSelection<Object> unassignedTable;
    public ListSingleSelection<String> targetMergeKey;

    @Tunable(description="Source Table:", gravity=0.1, groups={"Source"}, longDescription="The name of the table used as the base data in the merge", exampleStringValue="default node table")
    public ListSingleSelection<CyTable> getSourceTable() {
        return this.sourceTable;
    }

    public void setSourceTable(ListSingleSelection<CyTable> table) {
        List<Object> listOfGlobal;
        ListMultipleSelection<String> tempList = this.getColumnList((CyTable)table.getSelectedValue());
        if (!this.sourceMergeColumns.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.sourceMergeColumns.getPossibleValues().size() != tempList.getPossibleValues().size()) {
            this.sourceMergeColumns = tempList;
            this.sourceMergeKey = this.getKeyColumnList((CyTable)table.getSelectedValue());
        }
        if ((listOfGlobal = this.getPublicGlobalTables()).contains(table.getSelectedValue())) {
            if (listOfGlobal.size() == 1) {
                listOfGlobal.clear();
                listOfGlobal.add(NO_TABLES);
                this.targetMergeKey = new ListSingleSelection((Object[])new String[]{NO_TABLES});
                this.unassignedTable = new ListSingleSelection(listOfGlobal);
            } else {
                listOfGlobal.remove(table.getSelectedValue());
                this.unassignedTable = new ListSingleSelection(listOfGlobal);
                this.targetMergeKey = this.getKeyColumnList((CyTable)this.unassignedTable.getSelectedValue());
            }
        } else if (listOfGlobal.size() == 1 && !(this.unassignedTable.getSelectedValue() instanceof CyTable) || listOfGlobal.size() != this.unassignedTable.getPossibleValues().size() && listOfGlobal.size() > 0) {
            this.unassignedTable = new ListSingleSelection(listOfGlobal);
            this.targetMergeKey = this.getKeyColumnList((CyTable)this.unassignedTable.getSelectedValue());
        }
        if (!this.isTableGlobal((CyTable)table.getSelectedValue())) {
            if (this.mergeType.getPossibleValues().size() > 1) {
                this.mergeType = new ListSingleSelection((Object[])new String[]{COPY_COLUMNS});
            }
        } else if (this.mergeType.getPossibleValues().size() < 2) {
            this.mergeType = new ListSingleSelection((Object[])new String[]{COPY_COLUMNS, LINK_COLUMNS});
            this.mergeType.setSelectedValue((Object)COPY_COLUMNS);
        }
        this.sourceTable = table;
    }

    @Tunable(description="Select Columns:", gravity=0.2, groups={"Source", "Columns To Merge"}, listenForChange={"SourceTable", "SelectAllColumns"}, longDescription="A list of columns that will be brought into the merged table", exampleStringValue="PrimaryKey,SecondaryKey")
    public ListMultipleSelection<String> getSourceMergeColumns() {
        return this.sourceMergeColumns;
    }

    public void setSourceMergeColumns(ListMultipleSelection<String> columns) {
        this.sourceMergeColumns = columns;
    }

    @Tunable(description="Key column to merge", groups={"Source"}, gravity=0.4, listenForChange={"SourceTable"}, longDescription="The name of the columns that exists in both tables and is used to join rows", exampleStringValue="primary")
    public ListSingleSelection<String> getSourceMergeKey() {
        return this.sourceMergeKey;
    }

    public void setSourceMergeKey(ListSingleSelection<String> key) {
        this.sourceMergeKey = key;
    }

    @Tunable(description="Merge table to:", gravity=1.0, groups={"Target"}, xorChildren=true, longDescription="The destination path of the resultant merged table.  The choices are ''Network Collection'', ''Selected Networks'', or ''All Unassigned Tables''.", exampleStringValue="Selected Networks")
    public ListSingleSelection<String> getWhereMergeTable() {
        return this.whereMergeTable;
    }

    public void setWhereMergeTable(ListSingleSelection<String> chooser) {
        this.whereMergeTable = chooser;
    }

    @Tunable(description="Network Collection:", groups={"Target", "Select Network Collection"}, gravity=2.1, xorKey="a network collection", longDescription="The group of networks that will be merged into the source table", exampleStringValue="all")
    public ListSingleSelection<String> getTargetNetworkCollection() {
        return this.targetNetworkCollection;
    }

    public void setTargetNetworkCollection(ListSingleSelection<String> roots) {
        ListSingleSelection<String> tempList = this.getKeyColumnList((CyNetwork)this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue()), (TableType)((Object)this.dataTypeTargetForNetworkCollection.getSelectedValue()), "SHARED_ATTRS");
        if (!this.targetKeyNetworkCollection.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.targetKeyNetworkCollection.getPossibleValues().size() != tempList.getPossibleValues().size()) {
            this.targetKeyNetworkCollection = tempList;
        }
    }

    @Tunable(description="Merge data in:", groups={"Target", "Select Network Collection"}, gravity=2.2, xorKey="a network collection", longDescription="The collection of networks where the merged table will reside", exampleStringValue="MyCollection")
    public ListSingleSelection<TableType> getDataTypeTargetForNetworkCollection() {
        return this.dataTypeTargetForNetworkCollection;
    }

    public void setDataTypeTargetForNetworkCollection(ListSingleSelection<TableType> options) {
        ListSingleSelection<String> tempList = this.getKeyColumnList((CyNetwork)this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue()), (TableType)((Object)this.dataTypeTargetForNetworkCollection.getSelectedValue()), "SHARED_ATTRS");
        if (!this.targetKeyNetworkCollection.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.targetKeyNetworkCollection.getPossibleValues().size() != tempList.getPossibleValues().size()) {
            this.targetKeyNetworkCollection = tempList;
        }
    }

    @Tunable(description="Key column for network:", groups={"Target", "Select Network Collection"}, gravity=2.3, xorKey="a network collection", listenForChange={"DataTypeTargetForNetworkCollection", "TargetNetworkCollection"}, longDescription="The name of the primary column about which the merge is made", exampleStringValue="primary")
    public ListSingleSelection<String> getTargetKeyNetworkCollection() {
        return this.targetKeyNetworkCollection;
    }

    public void setTargetKeyNetworkCollection(ListSingleSelection<String> colList) {
        this.targetKeyNetworkCollection = colList;
    }

    @Tunable(description="Networks:", groups={"Target", "Select Networks"}, gravity=3.1, xorKey="selected networks only", longDescription="The list of networks where the merged table will be added", exampleStringValue="all")
    public ListMultipleSelection<String> getTargetNetworkList() {
        return this.targetNetworkList;
    }

    public void setTargetNetworkList(ListMultipleSelection<String> list) {
        this.targetNetworkList = list;
    }

    @Tunable(description="Unassigned table:", groups={"Target", "Select Unassigned Table"}, gravity=4.1, xorKey="an unassigned table", listenForChange={"SourceTable"}, longDescription="", exampleStringValue="")
    public ListSingleSelection<Object> getUnassignedTable() {
        return this.unassignedTable;
    }

    public void setUnassignedTable(ListSingleSelection<Object> tables) {
        if (tables.getSelectedValue() instanceof CyTable) {
            ListSingleSelection<String> tempList = this.getKeyColumnList((CyTable)tables.getSelectedValue());
            if (!this.targetMergeKey.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.targetMergeKey.getPossibleValues().size() != tempList.getPossibleValues().size()) {
                this.targetMergeKey = tempList;
                this.targetMergeKey = this.getKeyColumnList((CyTable)tables.getSelectedValue());
            }
        }
        this.unassignedTable = tables;
    }

    @Tunable(description="Key column to merge:", groups={"Target", "Select Unassigned Table"}, gravity=4.2, listenForChange={"UnassignedTable", "SourceTable"}, longDescription="", exampleStringValue="")
    public ListSingleSelection<String> getTargetMergeKey() {
        return this.targetMergeKey;
    }

    public void setTargetMergeKey(ListSingleSelection<String> key) {
        this.targetMergeKey = key;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Merge Data Table";
    }

    public MergeTablesTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.name2NetworkMap = new HashMap<String, CyNetwork>();
        this.name2RootMap = new HashMap<String, CyRootNetwork>();
        this.source2targetColumnMap = new HashMap<String, String>();
        this.tableSUIDs = new ArrayList<Long>();
        this.initTunable();
    }

    private final void initTunable() {
        ArrayList<CyTable> listOfTables = new ArrayList<CyTable>();
        ArrayList<Object> listOfUTables = new ArrayList<Object>();
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        for (CyTable tempTable : tableManager.getGlobalTables()) {
            if (!tempTable.isPublic()) continue;
            listOfTables.add(tempTable);
            listOfUTables.add(tempTable);
        }
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        Set networkSet = netManager.getNetworkSet();
        if (!networkSet.isEmpty()) {
            this.whereMergeTable = new ListSingleSelection((Object[])new String[]{NETWORK_COLLECTION, NETWORK_SELECTION, UNASSIGNED_TABLE});
            this.whereMergeTable.setSelectedValue((Object)NETWORK_COLLECTION);
            ArrayList<TableType> options = new ArrayList<TableType>();
            for (TableType type : TableType.values()) {
                options.add(type);
            }
            this.dataTypeTargetForNetworkCollection = new ListSingleSelection(options);
            this.dataTypeTargetForNetworkCollection.setSelectedValue((Object)TableType.NODE_ATTR);
            this.dataTypeTargetForNetworkList = new ListSingleSelection(options);
            this.dataTypeTargetForNetworkList.setSelectedValue((Object)TableType.NODE_ATTR);
            for (CyNetwork net : networkSet) {
                String netName = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
                this.name2NetworkMap.put(netName, net);
            }
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.name2NetworkMap.keySet());
            this.sort(names);
            this.targetNetworkList = names.isEmpty() ? new ListMultipleSelection((Object[])new String[]{NO_NETWORKS}) : new ListMultipleSelection(names);
            CyRootNetworkManager rootNetManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
            for (CyNetwork net : networkSet) {
                CyRootNetwork rootNet = rootNetManager.getRootNetwork(net);
                if (this.name2RootMap.containsValue(rootNet)) continue;
                this.name2RootMap.put((String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class), rootNet);
            }
            ArrayList<String> rootNames = new ArrayList<String>();
            rootNames.addAll(this.name2RootMap.keySet());
            this.sort(rootNames);
            this.targetNetworkCollection = new ListSingleSelection(rootNames);
            if (!rootNames.isEmpty()) {
                this.targetNetworkCollection.setSelectedValue((Object)((String)rootNames.get(0)));
                this.targetKeyNetworkCollection = this.getKeyColumnList((CyNetwork)this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue()), (TableType)((Object)this.dataTypeTargetForNetworkCollection.getSelectedValue()), "SHARED_ATTRS");
            }
            for (CyNetwork network : networkSet) {
                listOfTables.add(network.getDefaultNodeTable());
                listOfTables.add(network.getDefaultEdgeTable());
            }
        } else {
            this.whereMergeTable = new ListSingleSelection((Object[])new String[]{UNASSIGNED_TABLE});
            this.whereMergeTable.setSelectedValue((Object)UNASSIGNED_TABLE);
        }
        this.sourceTable = new ListSingleSelection(listOfTables);
        if (!this.isTableGlobal((CyTable)this.sourceTable.getSelectedValue())) {
            this.mergeType = new ListSingleSelection((Object[])new String[]{COPY_COLUMNS});
        } else {
            this.mergeType = new ListSingleSelection((Object[])new String[]{COPY_COLUMNS, LINK_COLUMNS});
            this.mergeType.setSelectedValue((Object)COPY_COLUMNS);
        }
        this.sourceMergeColumns = this.getColumnList((CyTable)this.sourceTable.getSelectedValue());
        this.sourceMergeKey = this.getKeyColumnList((CyTable)this.sourceTable.getSelectedValue());
        if (listOfUTables.size() > 1) {
            if (listOfUTables.contains(this.sourceTable.getSelectedValue())) {
                listOfUTables.remove(this.sourceTable.getSelectedValue());
            }
            this.unassignedTable = new ListSingleSelection(listOfUTables);
            this.targetMergeKey = this.getKeyColumnList((CyTable)this.unassignedTable.getSelectedValue());
        } else {
            listOfUTables.clear();
            listOfUTables.add(NO_TABLES);
            this.targetMergeKey = new ListSingleSelection((Object[])new String[]{NO_TABLES});
            this.unassignedTable = new ListSingleSelection(listOfUTables);
        }
    }

    public ListSingleSelection<String> getKeyColumnList(CyNetwork network, TableType tableType, String namespace) {
        CyTable table = this.getTable(network, tableType, "SHARED_ATTRS");
        ListSingleSelection<String> columns = this.getKeyColumnList(table);
        if (columns.getPossibleValues().contains("shared name")) {
            columns.setSelectedValue((Object)"shared name");
        }
        return columns;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Merge Tables");
        if (!((String)this.whereMergeTable.getSelectedValue()).matches(UNASSIGNED_TABLE) && this.name2RootMap.isEmpty()) {
            return;
        }
        if (!this.checkKeys()) {
            if (!this.isNewColumnVirtual()) {
                throw new IllegalArgumentException("Types of keys selected for tables are not valid.\nKeys must be of type Integer, Long, or String.");
            }
            throw new IllegalArgumentException("Types of keys selected for tables are not valid.\nKeys must be of type Integer, Long, or String, and must be the same type for a soft merge.");
        }
        try {
            if (((String)this.whereMergeTable.getSelectedValue()).matches(NETWORK_COLLECTION)) {
                this.mapTableToDefaultAttrs(this.getDataTypeOptions());
            } else if (((String)this.whereMergeTable.getSelectedValue()).matches(NETWORK_SELECTION)) {
                this.mapTableToLocalAttrs(this.getDataTypeOptions());
            } else if (((String)this.whereMergeTable.getSelectedValue()).matches(UNASSIGNED_TABLE)) {
                this.mapTableToUnassignedTable();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not execute table merge. Please check your parameters and try again.\n\n  (Reason: " + e.getMessage() + ")", e);
        }
    }

    private boolean isMappableColumn(CyColumn col) {
        String name = col.getName();
        Class type = col.getType();
        return (type == Integer.class || type == Long.class || type == String.class) && !name.equals("SUID") && !name.endsWith(".SUID");
    }

    private void mapTableToUnassignedTable() {
        CyTable tableChosen;
        if (!this.unassignedTable.getSelectedValue().toString().matches(NO_TABLES) && !(tableChosen = (CyTable)this.unassignedTable.getSelectedValue()).equals(this.sourceTable.getSelectedValue())) {
            this.applyMapping(tableChosen);
        }
    }

    private void mapTableToLocalAttrs(TableType tableType) {
        ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
        if (this.targetNetworkList.getSelectedValues().isEmpty()) {
            return;
        }
        if (!((String)this.targetNetworkList.getSelectedValues().get(0)).equals(NO_NETWORKS)) {
            for (String netName : this.targetNetworkList.getSelectedValues()) {
                networks.add(this.name2NetworkMap.get(netName));
            }
        }
        for (CyNetwork network : networks) {
            CyTable targetTable = this.getTable(network, tableType, "LOCAL_ATTRS");
            if (targetTable == null) continue;
            this.applyMapping(targetTable);
        }
    }

    private void mapTableToDefaultAttrs(TableType tableType) {
        CyTable targetTable = this.getTable((CyNetwork)this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue()), tableType, "SHARED_DEFAULT_ATTRS");
        if (targetTable != null) {
            this.applyMapping(targetTable);
        }
    }

    private CyTable getTable(CyNetwork network, TableType tableType, String namespace) {
        if (tableType == TableType.NODE_ATTR) {
            return network.getTable(CyNode.class, namespace);
        }
        if (tableType == TableType.EDGE_ATTR) {
            return network.getTable(CyEdge.class, namespace);
        }
        if (tableType == TableType.NETWORK_ATTR) {
            return network.getTable(CyNetwork.class, namespace);
        }
        logger.warn("The selected table type is not valie. \nTable needs to be one of these types: " + TableType.NODE_ATTR + ", " + TableType.EDGE_ATTR + ", " + TableType.NETWORK_ATTR + ".");
        return null;
    }

    private void applyMapping(CyTable targetTable) {
        ArrayList<CyColumn> columns = new ArrayList<CyColumn>();
        CyColumn tempCol = null;
        for (String colName : this.sourceMergeColumns.getSelectedValues()) {
            tempCol = ((CyTable)this.sourceTable.getSelectedValue()).getColumn(colName);
            if (tempCol == null) continue;
            columns.add(tempCol);
        }
        this.copyColumns((CyTable)this.sourceTable.getSelectedValue(), columns, targetTable, this.isNewColumnVirtual());
        if (!this.isNewColumnVirtual()) {
            this.copyRows((CyTable)this.sourceTable.getSelectedValue(), columns, targetTable);
        }
        this.tableSUIDs.add(targetTable.getSUID());
    }

    private CyColumn getJoinTargetColumn(CyTable targetTable) {
        String joinKeyName = "name";
        if (((String)this.whereMergeTable.getSelectedValue()).matches(NETWORK_COLLECTION)) {
            joinKeyName = (String)this.targetKeyNetworkCollection.getSelectedValue();
        }
        if (((String)this.whereMergeTable.getSelectedValue()).matches(UNASSIGNED_TABLE)) {
            joinKeyName = (String)this.targetMergeKey.getSelectedValue();
        }
        return targetTable.getColumn(joinKeyName);
    }

    private void copyRows(CyTable inputTable, List<CyColumn> sourceColumns, CyTable targetTable) {
        CyRow sourceRow = null;
        CyColumn targetKeyColumn = this.getJoinTargetColumn(targetTable);
        for (CyRow targetRow : targetTable.getAllRows()) {
            Object key = targetRow.get(targetKeyColumn.getName(), targetKeyColumn.getType());
            if (key == null) continue;
            if (key.getClass() != this.getMergeKeyColumn().getType()) {
                try {
                    key = DataUtils.convertString(key.toString(), this.getMergeKeyColumn().getType());
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (this.isMergeColumnKeyColumn()) {
                if (!inputTable.rowExists(key)) continue;
                sourceRow = inputTable.getRow(key);
            } else {
                if (inputTable.getMatchingRows(this.getMergeKeyColumn().getName(), key).isEmpty()) continue;
                sourceRow = (CyRow)inputTable.getMatchingRows(this.getMergeKeyColumn().getName(), key).iterator().next();
            }
            if (sourceRow == null) continue;
            for (CyColumn col : sourceColumns) {
                String targetColName;
                if (col == this.getMergeKeyColumn() || (targetColName = this.source2targetColumnMap.get(col.getName())) == null) continue;
                if (col.getType() == List.class) {
                    targetRow.set(targetColName, (Object)sourceRow.getList(col.getName(), col.getListElementType()));
                    continue;
                }
                targetRow.set(targetColName, sourceRow.get(col.getName(), col.getType()));
            }
        }
    }

    private void copyColumns(CyTable inputTable, List<CyColumn> sourceColumns, CyTable targetTable, boolean addVirtual) {
        for (CyColumn col : sourceColumns) {
            if (col == this.getMergeKeyColumn()) continue;
            String targetColName = col.getName();
            if (!this.isMergeColumnKeyColumn()) {
                addVirtual = false;
            }
            if (targetTable.getColumn(targetColName) == null) {
                if (!addVirtual) {
                    if (col.getType() == List.class) {
                        targetTable.createListColumn(targetColName, col.getListElementType(), col.isImmutable());
                    } else {
                        targetTable.createColumn(targetColName, col.getType(), col.isImmutable(), col.getDefaultValue());
                    }
                } else {
                    targetTable.addVirtualColumn(targetColName, col.getName(), inputTable, this.getJoinTargetColumn(targetTable).getName(), false);
                }
            } else {
                CyColumn targetCol = targetTable.getColumn(targetColName);
                if (targetCol.getType() != col.getType() || col.getType() == List.class && targetCol.getListElementType() != col.getListElementType()) {
                    logger.error("Column '" + targetColName + "' has a different type in the target table -- skipping column");
                    continue;
                }
            }
            this.source2targetColumnMap.put(col.getName(), targetColName);
        }
    }

    public boolean checkKeys() {
        CyColumn joinTargetColumn = null;
        if (((String)this.whereMergeTable.getSelectedValue()).matches(NETWORK_COLLECTION)) {
            joinTargetColumn = this.getJoinTargetColumn(this.getTable((CyNetwork)this.name2RootMap.get(this.targetNetworkCollection.getSelectedValue()), this.getDataTypeOptions(), "USER"));
        } else if (((String)this.whereMergeTable.getSelectedValue()).matches(UNASSIGNED_TABLE) && !this.unassignedTable.getSelectedValue().equals(NO_TABLES)) {
            joinTargetColumn = this.getJoinTargetColumn((CyTable)this.unassignedTable.getSelectedValue());
        }
        if (!this.isMappableColumn(this.getMergeKeyColumn())) {
            return false;
        }
        return joinTargetColumn == null || !(!this.isNewColumnVirtual() ? !this.isMappableColumn(joinTargetColumn) : joinTargetColumn.getType() != this.getMergeKeyColumn().getType());
    }

    private ListMultipleSelection<String> getColumnList(CyTable table) {
        String tempName = null;
        ArrayList<String> colNames = new ArrayList<String>();
        for (CyColumn col : table.getColumns()) {
            tempName = col.getName();
            if (tempName.matches("shared name") || tempName.matches("name") || tempName.matches("SUID") || tempName.matches("selected")) continue;
            colNames.add(tempName);
        }
        this.sort(colNames);
        ListMultipleSelection columns = new ListMultipleSelection(colNames);
        return columns;
    }

    private ListSingleSelection<String> getKeyColumnList(CyTable table) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (CyColumn col : table.getColumns()) {
            if (!this.isMappableColumn(col)) continue;
            colNames.add(col.getName());
        }
        this.sort(colNames);
        ListSingleSelection columns = new ListSingleSelection(colNames);
        if (colNames.contains("name")) {
            columns.setSelectedValue((Object)"name");
        } else if (!table.getPrimaryKey().getName().matches("SUID") && colNames.contains(table.getPrimaryKey().getName())) {
            columns.setSelectedValue((Object)table.getPrimaryKey().getName());
        }
        return columns;
    }

    private void sort(List<String> names) {
        if (!names.isEmpty()) {
            final Collator collator = Collator.getInstance(Locale.getDefault());
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    return collator.compare(s1, s2);
                }
            });
        }
    }

    private boolean isNewColumnVirtual() {
        return this.mergeType.getSelectedValue() == LINK_COLUMNS;
    }

    private boolean isMergeColumnKeyColumn() {
        return ((CyTable)this.sourceTable.getSelectedValue()).getPrimaryKey() == this.getMergeKeyColumn();
    }

    private CyColumn getMergeKeyColumn() {
        return ((CyTable)this.sourceTable.getSelectedValue()).getColumn((String)this.sourceMergeKey.getSelectedValue());
    }

    private List<Object> getPublicGlobalTables() {
        ArrayList<Object> listTables = new ArrayList<Object>();
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        for (CyTable tempTable : tableManager.getGlobalTables()) {
            if (!tempTable.isPublic()) continue;
            listTables.add(tempTable);
        }
        return listTables;
    }

    private boolean isTableGlobal(CyTable table) {
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        for (CyTable tempTable : tableManager.getGlobalTables()) {
            if (!tempTable.equals(table)) continue;
            return true;
        }
        return false;
    }

    private TableType getDataTypeOptions() {
        if (((String)this.whereMergeTable.getSelectedValue()).matches(NETWORK_COLLECTION)) {
            return (TableType)((Object)this.dataTypeTargetForNetworkCollection.getSelectedValue());
        }
        return (TableType)((Object)this.dataTypeTargetForNetworkList.getSelectedValue());
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            Object res = "";
            for (Long suid : this.tableSUIDs) {
                res = (String)res + suid.toString() + ",";
            }
            return ((String)res).substring(0, ((String)res).length() - 1);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.tableSUIDs == null || this.tableSUIDs.size() == 0) {
                    return "{}";
                }
                Object strRes = "{\"tables\":[";
                for (Long suid : this.tableSUIDs) {
                    strRes = (String)strRes + suid.toString() + ",";
                }
                return ((String)strRes).substring(0, ((String)strRes).length() - 1) + "]}";
            };
            return res;
        }
        return this.tableSUIDs;
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (!this.isMergeColumnKeyColumn() && this.isNewColumnVirtual()) {
            try {
                this.mergeType.setSelectedValue((Object)COPY_COLUMNS);
                errMsg.append("Source Key column needs to be the key column of source table to apply a soft merge.\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                return TunableValidator.ValidationState.INVALID;
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return TunableValidator.ValidationState.OK;
    }

    static enum TableType {
        NODE_ATTR("Node Table Columns", CyNode.class),
        EDGE_ATTR("Edge Table Columns", CyEdge.class),
        NETWORK_ATTR("Network Table Columns", CyNetwork.class);

        private final String name;
        private final Class<? extends CyIdentifiable> type;

        private TableType(String name, Class<? extends CyIdentifiable> type) {
            this.name = name;
            this.type = type;
        }

        public Class<? extends CyIdentifiable> getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

