/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetValueTask
extends AbstractTableDataTask
implements ObservableTask {
    Object resultValue;
    CyTable table;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Key value for row", context="nogui", longDescription="Specifies a row of a table using the primary key as the indentifier", exampleStringValue="Key")
    public String keyValue;
    @Tunable(description="Name of column", context="nogui", longDescription="Specifies the name of a column in the table", exampleStringValue="Property")
    public String column;

    public GetValueTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.table = this.tableTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.keyValue == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Key of desired row must be specified");
            return;
        }
        if (this.column == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column name must be specified");
            return;
        }
        CyColumn primaryKColumn = this.table.getPrimaryKey();
        Class keyType = primaryKColumn.getType();
        Object key = null;
        try {
            key = DataUtils.convertString(this.keyValue, keyType);
        }
        catch (NumberFormatException nfe) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName() + ": " + nfe.getMessage());
            return;
        }
        if (key == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName());
            return;
        }
        CyColumn targetColumn = this.table.getColumn(this.column);
        if (targetColumn == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find the '" + this.column + "' column in this table");
            return;
        }
        CyRow row = this.table.getRow(key);
        if (row == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find a '" + this.keyValue + "' row in this table");
            return;
        }
        Class columnType = targetColumn.getType();
        if (targetColumn.getType().equals(List.class)) {
            Class elementType = targetColumn.getListElementType();
            List valueList = row.getList(this.column, elementType);
            tm.showMessage(TaskMonitor.Level.INFO, " " + this.column + "=" + (valueList == null ? "<null>" : DataUtils.convertData(valueList)));
            this.resultValue = valueList;
        } else {
            Object value = row.get(this.column, columnType);
            tm.showMessage(TaskMonitor.Level.INFO, " " + this.column + "=" + (value == null ? "<null>" : DataUtils.convertData(value)));
            this.resultValue = value;
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (this.resultValue == null) {
            return null;
        }
        if (requestedType.equals(String.class)) {
            return DataUtils.convertData(this.resultValue);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> "{ \"table\": " + this.table.getSUID() + ", \"column\":" + this.column + ", \"row\":" + this.keyValue + " \"value\":" + DataUtils.convertDataJSON(this.resultValue) + "}";
            return res;
        }
        return this.resultValue;
    }
}

