/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetRowTask
extends AbstractTableDataTask
implements ObservableTask {
    CyRow row;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Key value for row", context="nogui", longDescription="Specifies a row of a table using the primary key as the indentifier", exampleStringValue="Key")
    public String keyValue = null;

    public GetRowTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        CyTable table = this.tableTunable.getTable();
        if (table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.keyValue == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Key of desired row must be specified");
            return;
        }
        CyColumn primaryKColumn = table.getPrimaryKey();
        Class keyType = primaryKColumn.getType();
        Object key = null;
        try {
            key = DataUtils.convertString(this.keyValue, keyType);
        }
        catch (NumberFormatException nfe) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName() + ": " + nfe.getMessage());
            return;
        }
        if (key == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName());
            return;
        }
        if (!table.rowExists(key)) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Row " + this.keyValue + " doesn't exist");
            return;
        }
        this.row = table.getRow(key);
        tm.showMessage(TaskMonitor.Level.INFO, "Retreived row '" + this.keyValue + "':");
        for (CyColumn column : table.getColumns()) {
            String columnName = column.getName();
            Class columnType = column.getType();
            if (column.getType().equals(List.class)) {
                Class elementType = column.getListElementType();
                List valueList = this.row.getList(columnName, elementType);
                if (valueList == null) continue;
                tm.showMessage(TaskMonitor.Level.INFO, "     " + columnName + "=" + DataUtils.convertData(valueList));
                continue;
            }
            Object value = this.row.get(columnName, columnType);
            if (value == null) continue;
            tm.showMessage(TaskMonitor.Level.INFO, "     " + columnName + "=" + DataUtils.convertData(value));
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyRow.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (this.row == null) {
            return null;
        }
        if (requestedType.equals(String.class)) {
            return this.row.toString();
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.row == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return cyJSONUtil.toJson((CyIdentifiable)this.row);
            };
            return res;
        }
        return this.row;
    }
}

