/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnListTunable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.NodeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class GetNodeAttributeTask
extends AbstractTableDataTask
implements ObservableTask {
    private Map<CyIdentifiable, Map<String, Object>> nodeDataMap;
    @ContainsTunables
    public NodeTunable nodeTunable;
    @ContainsTunables
    public ColumnListTunable columnTunable;
    public CyTable nodeTable;

    public GetNodeAttributeTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.nodeTunable = new NodeTunable(serviceRegistrar);
        this.columnTunable = new ColumnListTunable();
    }

    public void run(TaskMonitor tm) {
        CyNetwork network = this.nodeTunable.getNetwork();
        this.nodeTable = this.getNetworkTable(network, CyNode.class, this.columnTunable.getNamespace());
        this.nodeDataMap = new HashMap<CyIdentifiable, Map<String, Object>>();
        for (CyNode node : this.nodeTunable.getNodeList()) {
            Map<String, Object> nodeData = this.getCyIdentifierData(this.nodeTable, (CyIdentifiable)node, this.columnTunable.getColumnNames(this.nodeTable));
            if (nodeData == null || nodeData.size() == 0) continue;
            this.nodeDataMap.put((CyIdentifiable)node, nodeData);
            tm.showMessage(TaskMonitor.Level.INFO, "   Node table values for node " + DataUtils.getNodeName(this.nodeTable, node) + ":");
            for (String column : nodeData.keySet()) {
                if (nodeData.get(column) == null) continue;
                tm.showMessage(TaskMonitor.Level.INFO, "        " + column + "=" + DataUtils.convertData(nodeData.get(column)));
            }
        }
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return DataUtils.convertMapToString(this.nodeDataMap);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.nodeDataMap == null) {
                    return "[]";
                }
                StringBuilder output = new StringBuilder("[");
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                List<CyColumn> cyColumn = this.columnTunable.getColumnList(this.nodeTable);
                CyColumn[] cyColumnArray = cyColumn.size() > 0 ? cyColumn.toArray(new CyColumn[0]) : new CyColumn[]{};
                int count = this.nodeDataMap.size();
                for (CyIdentifiable node : this.nodeDataMap.keySet()) {
                    CyRow row = this.nodeTable.getRow((Object)node.getSUID());
                    output.append(" " + cyJSONUtil.toJson(row, cyColumnArray));
                    if (count > 1) {
                        output.append(",\n");
                    }
                    --count;
                }
                output.append("\n]");
                return output.toString();
            };
            return res;
        }
        return this.nodeDataMap;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(Map.class, String.class, JSONResult.class);
    }
}

