/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnListTunable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetNetworkAttributeTask
extends AbstractTableDataTask
implements ObservableTask {
    @Tunable(description="Network", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;
    @ContainsTunables
    public ColumnListTunable columnTunable = new ColumnListTunable();
    private Map<String, Object> networkData;
    private CyTable networkTable;

    public GetNetworkAttributeTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        this.networkTable = this.getNetworkTable(this.network, CyNetwork.class, this.columnTunable.getNamespace());
        this.networkData = this.getCyIdentifierData(this.networkTable, (CyIdentifiable)this.network, this.columnTunable.getColumnNames(this.networkTable));
        tm.showMessage(TaskMonitor.Level.INFO, "   Attribute values for network " + DataUtils.getNetworkName(this.network) + ":");
        for (String column : this.networkData.keySet()) {
            if (this.networkData.get(column) == null) continue;
            tm.showMessage(TaskMonitor.Level.INFO, "        " + column + "=" + DataUtils.convertData(this.networkData.get(column)));
        }
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return DataUtils.convertMapToString(this.networkData);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.networkData == null) {
                    return "[]";
                }
                StringBuilder output = new StringBuilder("[");
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                List<CyColumn> cyColumn = this.columnTunable.getColumnList(this.networkTable);
                CyColumn[] cyColumnArray = cyColumn.size() > 0 ? cyColumn.toArray(new CyColumn[0]) : new CyColumn[]{};
                CyRow row = this.networkTable.getRow((Object)this.network.getSUID());
                output.append(" " + cyJSONUtil.toJson(row, cyColumnArray));
                output.append("\n]");
                return output.toString();
            };
            return res;
        }
        return this.networkData;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(Map.class, String.class, JSONResult.class);
    }
}

