/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetColumnTask
extends AbstractTableDataTask
implements ObservableTask {
    CyColumn returnValue;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Name of column", context="nogui", longDescription="Specifies the name of a column in the table", exampleStringValue="Property")
    public String column;

    public GetColumnTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        CyTable table = this.tableTunable.getTable();
        if (table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.column == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column name must be specified");
            return;
        }
        this.returnValue = table.getColumn(this.column);
        if (this.returnValue == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column '" + this.column + "' doesn't exist in table: " + table.toString());
            return;
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Retrieved column: " + this.returnValue.toString());
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyColumn.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (this.returnValue == null) {
            return null;
        }
        if (requestedType.equals(CyColumn.class)) {
            return this.returnValue;
        }
        if (requestedType.equals(String.class)) {
            return this.returnValue.getName();
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.returnValue == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return cyJSONUtil.toJson(this.returnValue, true, true);
            };
            return res;
        }
        return this.returnValue;
    }
}

